// CArtAgO artifact code for project extraamasPOC

package extraamasPOC;

import java.util.LinkedList;

import cartago.*;

public class OfficeBuilding extends Artifact {
	protected LinkedList<String> agentNames = new LinkedList<String>();
	protected LinkedList<String> agentFinished = new LinkedList<String>();

	protected long beginTime;
	boolean counting;
	final static long TICK_TIME = 100;
	
	void init() 
	{
		beginTime = System.currentTimeMillis();
		counting = false;
	}
	
	@OPERATION void start()
	{
		if (!counting)
		{
			counting = true;
			execInternalOp("count");
		} 
	}
	
	@INTERNAL_OPERATION 
	void count(){
		while (counting){
		  signal("tick",System.currentTimeMillis()-beginTime);
		  await_time(TICK_TIME);
		}
	}
	
	@OPERATION
	 public void connect(String agentName)
	 { 
		 if(!agentNames.contains(agentName))
		 {
			 agentNames.add(agentName);
			 System.out.println("ADD " + agentName);
			 execInternalOp("start");
		 }
	 }
	
	@OPERATION
	 public void finish(String agentName)
	 { 
		 if(!agentNames.contains(agentName))
		 {
			 System.out.println("WARNING : " + agentName + " was not registered as an agent");
		 }
		 else
		 {
			 agentFinished.add(agentName);
			 System.out.println(agentName + " has achieved its goal");
			 if(agentNames.size()==agentFinished.size())
			 {
				 System.out.println("All the registered agents have achieved their goals. Terminating the simulation now.");
				 System.exit(0); 
			 }
		 }
	 }
	
	@OPERATION
	 public void getTime(OpFeedbackParam<Long> time)
	 { 
		 time.set(System.currentTimeMillis());
	 }
	
	@OPERATION
	 public void goToGroundFloor(String agentName)
	 {
		 signal("done",agentName,"goToGroundFloor",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void goToSecondFloor(String agentName)
	 {
		 signal("done",agentName,"goToSecondFloor",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void goToThirdFloor(String agentName)
	 {
		 signal("done",agentName,"goToThirdFloor",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void buyCoffee(String agentName)
	 {
		 signal("done",agentName,"buyCoffee",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void drinkCoffee(String agentName)
	 {
		 signal("done",agentName,"drinkCoffee",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void buySnack(String agentName)
	 {
		 signal("done",agentName,"buySnack",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void eatSnack(String agentName)
	 {
		 signal("done",agentName,"eatSnack",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void takeBook(String agentName)
	 {
		 signal("done",agentName,"takeBook",System.currentTimeMillis()-beginTime);
	 }
	
	@OPERATION
	 public void readBook(String agentName)
	 {
		 signal("done",agentName,"readBook",System.currentTimeMillis()-beginTime);
	 }
}

