// Agent randomDecision in project obfuscationPOC

{ include("$jacamoJar/templates/common-cartago.asl") }
{ include("$jacamoJar/templates/common-moise.asl") }
{ include("inc/planLib.asl") }

// ========================================= //
// This agent picks a random intendable goal //
// and achieve this goal with random choices //
// ========================================= //

/* Initial beliefs and rules */

// Decision process in case of OR-node
// Options is a list of actions or goals
decideIn(Choice,Options):-
  .nth(N,Options,Choice)
  & .length(Options,L)
  & random(X)
  & X> N*1.0/L
  & X< (N+1)*1.0/L.

/* Initial goals */

// initialize the random number generation
!regenRandomNumber.

// The following goals define the intended goal of the agent.
// The last one let the agent herself decide randomly her goal

//!haveCoffeeBreak
//!haveSnack
//!improveSOTA
!start.

/* Plans */

+!regenRandomNumber : true
  <- .random(X);
     -+random(X).
     
+!start : not connected(true) & baseWaitingTime(T)
  <- +connected(true);
     .wait(T);
     lookupArtifact("world",WorldId);
     focus(WorldId);
     .my_name(Name);
     connect(Name);
     !start.

//[haveCoffeeBreak,haveSnack,improveSOTA]
+!start : not myGoal(_) & decideIn("haveCoffeeBreak",["haveCoffeeBreak","haveSnack","improveSOTA"]) & baseWaitingTime(T)
  <- .wait(T);
     .print("I pick the goal 'haveCoffeeBreak'");
     !regenRandomNumber;
     +myGoal(haveCoffeeBreak)
     !start.

+!start : not myGoal(_) & decideIn("haveSnack",["haveCoffeeBreak","haveSnack","improveSOTA"]) & baseWaitingTime(T)
  <- .wait(T);
     .print("I pick the goal 'haveSnack'");
     !regenRandomNumber;
     +myGoal(haveSnack)
     !start.
     
+!start : not myGoal(_) & decideIn("improveSOTA",["haveCoffeeBreak","haveSnack","improveSOTA"]) & baseWaitingTime(T)
  <- .wait(T);
     .print("I pick the goal 'improveSOTA'");
     !regenRandomNumber;
     +myGoal(improveSOTA)
     !start.
     
+!start : myGoal(haveCoffeeBreak) & baseWaitingTime(T)
  <- .wait(T);
     .print("hello, I will have a coffee break");
     !regenRandomNumber;
     !haveCoffeeBreak.

+!start : myGoal(haveSnack) & baseWaitingTime(T)
  <- .wait(T);
     .print("hello, I will have a snack");
     !regenRandomNumber;
     !haveSnack.
     
+!start : myGoal(improveSOTA) & baseWaitingTime(T)
  <- .wait(T);
     .print("hello, I will look for a good book to improve my state-of-the-art");
     !regenRandomNumber;
     !improveSOTA.
   