// Agent onlooker in project obfuscationPOC

{ include("$jacamoJar/templates/common-cartago.asl") }
{ include("$jacamoJar/templates/common-moise.asl") }
{ include("inc/situationAwareness.asl") }
{ include("inc/planForestDescriptor.asl") }
{ include("inc/behaviorAnalysis.asl") }

/* Initial goals */

!start.

/* Plans */

+!reactToBehavior(Agent) : behavior(Agent,Behavior) 
    <- !detailBehaviorExplanation(Agent,Behavior).
    
+!reactToBehavior(Agent) : true
  <- .print("Something wrong happens").  

+!detailBehaviorExplanation(Agent,Behavior):
  listOfIntendableGoals(IGs)
  & time(T)
  & exploreExplanations(Behavior, [],Exp, IGs)
  & countPlansInExplanationSet(Exp,[],PlansNumbersList)
  & searchMostProbablePlan(PlansNumbersList,P,N)
  & getSpecificCountPlanInExplanationSet(haveCoffeeBreak,PlansNumbersList,NofHaveCoffeeBreak)
  & getSpecificCountPlanInExplanationSet(haveSnack,PlansNumbersList,NofHaveSnack)
  & getSpecificCountPlanInExplanationSet(improveSOTA,PlansNumbersList,NofImproveSOTA)
  <-  .length(Exp, L);
      jia.shannonEntropy(H,NofHaveCoffeeBreak,NofHaveSnack,NofImproveSOTA);
      .print("Agent=", Agent, " T=", T," MPG=", P," Entropy=", H, "(" , NofHaveCoffeeBreak, ",", NofHaveSnack, ",", NofImproveSOTA, ")");
      .print("I can explain the behavior ", Behavior, " of agent ", Agent, " with the ", L ," possible explanations : ", Exp).

/* Plans */

+!start : baseWaitingTime(T) 
  <- .wait(T);
     lookupArtifact("world",WorldId);
     focus(WorldId);
     .my_name(Name);
     connect(Name);
     .print("hello world.");
     !declareAsFinished.

+!declareAsFinished : baseWaitingTime(T)
  <- .wait(T); // To do let the other agents connect to the artifact
     .my_name(Name);
     finish(Name).