// Agent obfuscator in project obfuscationPOC
{ include("$jacamoJar/templates/common-cartago.asl") }
{ include("$jacamoJar/templates/common-moise.asl") }
{ include("inc/planLib.asl") }
{ include("inc/situationAwareness.asl") }
{ include("inc/planForestDescriptor.asl") }
{ include("inc/behaviorAnalysis.asl") }

/* Initial beliefs and rules */

// Decision process in case of OR-node
// Options is a list of actions or goals
decideIn(Choice,Options):-
  myName(Name)
  & myGoal(Tree)
  & time(T)
  & behavior(Name,Behavior)
  & makeEntropyList(T,Options,Tree,Behavior,EntropyList)
  & pickTheMostObfuscatingOptionIn(EntropyList,Choice,_).

/* Initial goals */
!start.

/* Plans */
+!regenRandomNumber : true
  <- .random(X);
     -+random(X).
     
+!reactToBehavior(Agent) : true. // TODO : react to the others' behavior if they don't obfuscate enough their goals  
  
+!start : not connected(true) & baseWaitingTime(T)
  <- +connected(true);
     .wait(T);
     lookupArtifact("world",WorldId);
     focus(WorldId);
     .my_name(Name);
     connect(Name);
     +myName(Name);
     +behavior(Name,[]); // required to decide the first action if necessary
     .print("hello world.");
     !start.

+!start : myGoal(haveCoffeeBreak) & baseWaitingTime(T)
  <- .wait(T);
     .print("hello, I will have a coffee break");
     !haveCoffeeBreak.

+!start : myGoal(haveSnack) & baseWaitingTime(T)
  <- .wait(T);
     .print("hello, I will have a snack");
     !haveSnack.
     
+!start : myGoal(improveSOTA) & baseWaitingTime(T)
  <- .wait(T);
     .print("hello, I will look for a good book to improve my state-of-the-art");
     !improveSOTA.
