// planLib in project obfuscationPOC

/* Plans */

// Intendable goals
+!haveCoffeeBreak : decideIn(Choice,[goToThirdFloor,goToGroundFloor])
  <- !findCoffeeMachine(Choice);
     !buyCoffee;
     !enjoyCoffeeAnywhere;
     !finishIfIGotCoffee.
    
+!findCoffeeMachine(goToGroundFloor) : true
  <- !goToGroundFloor.
  
+!findCoffeeMachine(goToThirdFloor) : true
  <- !goToThirdFloor.
  
 +!haveSnack : decideIn(Choice,[goToThirdFloor,goToGroundFloor])
  <- !findVendingMachine(Choice);
     !buySnack;
     !enjoySnackAnywhere;
     !finishIfIGotSnack.
    
+!findVendingMachine(goToGroundFloor) : true
  <- !goToGroundFloor.
  
+!findVendingMachine(goToThirdFloor) : true
  <- !goToThirdFloor.

+!improveSOTA : true
  <- !goToThirdFloor;
     !takeBook;
     !readBookAnywhere;
     !finishIfIGotBook.

+!enjoyCoffeeAnywhere : true
  <- !goToSecondFloor;
     !drinkCoffee.
  
+!enjoySnackAnywhere : true
  <- !goToSecondFloor;
     !eatSnack.
     
+!readBookAnywhere : true
  <- !goToSecondFloor;
     !readBook.

// other goals
+!goToGroundFloor : baseWaitingTime(T)
  <- .my_name(Name);
     goToGroundFloor(Name);
     .wait(T);
     .print("I move to the ground floor").
     
+!goToSecondFloor : baseWaitingTime(T)
  <- .my_name(Name);
     goToSecondFloor(Name);
     +myFloor(2);
     .wait(T);
     .print("I move to the second floor").
     
+!goToThirdFloor : baseWaitingTime(T)
  <- .my_name(Name);
     goToThirdFloor(Name);
     .wait(T);
     .print("I move to the third floor").
     
+!buyCoffee : baseWaitingTime(T)
  <- .my_name(Name);
     buyCoffee(Name);
     .wait(T);
     .print("I buy a coffe").
     
+!drinkCoffee : baseWaitingTime(T)
  <- .my_name(Name);
     drinkCoffee(Name);
     +gotCoffee;
     .wait(T);
     .print("I drink my coffe").
     
+!buySnack : baseWaitingTime(T)
  <- .my_name(Name);
     buySnack(Name);
     .wait(T);
     .print("I buy a snack").
     
+!eatSnack : baseWaitingTime(T)
  <- .my_name(Name);
     eatSnack(Name);
     +gotSnack;
     .wait(T);
     .print("I eat my snack").
     
+!takeBook : baseWaitingTime(T)
  <- .my_name(Name);
     takeBook(Name);
     .wait(T);
     .print("I take a book").
     
+!readBook : baseWaitingTime(T)
  <- .my_name(Name);
     readBook(Name);
     +gotBook;
     .wait(T);
     .print("I read the book").
     
+!finishIfIGotCoffee : gotCoffee & myFloor(2)
  <- .my_name(Name);
     finish(Name).
     
+!finishIfIGotCoffee : baseWaitingTime(T)
  <- .wait(T);
  	 !finishIfIGotCoffee.
     
+!finishIfIGotSnack : gotSnack & myFloor(2)
  <- .my_name(Name);
     finish(Name).
     
+!finishIfIGotSnack : baseWaitingTime(T)
  <- .wait(T);
  	 !finishIfIGotSnack.
     
+!finishIfIGotBook : gotBook & myFloor(2)
  <- .my_name(Name);
     finish(Name).
     
+!finishIfIGotBook : baseWaitingTime(T)
  <- .wait(T);
  	 !finishIfIGotBook.

     