

//define transitivity on isSonOf
tIsSonOf(A1,A2,P):- isSonOf(A1,A2,P).
tIsSonOf(A1,A2,P):- isSonOf(A1,A3,P) & tIsSonOf(A3,A2,P).

isLeafOf(A,P):- tIsSonOf(A,P,P) & not isSonOf(_,A,P).

// Description of the plantree forest
listOfIntendableGoals([haveCoffeeBreak,haveSnack,improveSOTA]).

// Name of the leafs (to match with the signals)
leaf(goToGroundFloor,"goToGroundFloor").
leaf(goToSecondFloor,"goToSecondFloor").
leaf(goToThirdFloor,"goToThirdFloor").
leaf(buyCoffee,"buyCoffee").
leaf(drinkCoffee,"drinkCoffee").
leaf(buySnack,"buySnack").
leaf(eatSnack,"eatSnack").
leaf(takeBook,"takeBook").
leaf(readBook,"readBook").

//****** First plan tree ******
isIntendableGoal(haveCoffeeBreak,"haveCoffeeBreak").

isSonOf(findCoffeeMachine,haveCoffeeBreak,haveCoffeeBreak).
isSonOf(buyCoffee,haveCoffeeBreak,haveCoffeeBreak).
isSonOf(enjoyCoffeeAnywhere,haveCoffeeBreak,haveCoffeeBreak).

isSonOf(goToGroundFloor,findCoffeeMachine,haveCoffeeBreak).
isSonOf(goToThirdFloor,findCoffeeMachine,haveCoffeeBreak).
isSonOf(goToSecondFloor,haveCoffeeBreak,haveCoffeeBreak).
isSonOf(drinkCoffee,haveCoffeeBreak,haveCoffeeBreak).

// Ordered AND-nodes
orderConstraint(findCoffeeMachine,buyCoffee,haveCoffeeBreak).
orderConstraint(buyCoffee,enjoyCoffeeAnywhere,haveCoffeeBreak).

// OR-nodes
exclusionConstraint(goToGroundFloor,goToThirdFloor,haveCoffeeBreak).

//****** Second plan tree ******
isIntendableGoal(haveSnack,"haveSnack").

isSonOf(findVendingMachine,haveSnack,haveSnack).
isSonOf(buySnack,haveSnack,haveSnack).
isSonOf(enjoySnackAnywhere,haveSnack,haveSnack).

isSonOf(goToGroundFloor,findVendingMachine,haveSnack).
isSonOf(goToThirdFloor,findVendingMachine,haveSnack).
isSonOf(goToSecondFloor,enjoySnackAnywhere,haveSnack).
isSonOf(eatSnack,enjoySnackAnywhere,haveSnack).

// Ordered AND-nodes
orderConstraint(findVendingMachine,buySnack,haveSnack).
orderConstraint(buySnack,enjoySnackAnywhere,haveSnack).

// OR-nodes
exclusionConstraint(goToGroundFloor,goToThirdFloor,haveSnack).

//****** Third plan tree ******
isIntendableGoal(improveSOTA,"improveSOTA").

isSonOf(goToThirdFloor,improveSOTA,improveSOTA).
isSonOf(takeBook,improveSOTA,improveSOTA).
isSonOf(readBookAnywhere,improveSOTA,improveSOTA).

isSonOf(goToSecondFloor,readBookAnywhere,improveSOTA).
isSonOf(readBook,readBookAnywhere,improveSOTA).

// Ordered AND-nodes
orderConstraint(goToThirdFloor,takeBook,improveSOTA).
orderConstraint(takeBook,readBookAnywhere,improveSOTA).


