// Agent behaviorAnalysis in project obfuscationPOC

// Concatenate two lists
// concat([a,b,c],[d,e,f],X). -> [a,b,c,d,e,f]
concat([], List, List).
concat([Head|Tail], List, [Head|Rest]) :-
    concat(Tail, List, Rest).

// Reverse a list
// Call : reverse([a,b,c],X,[])
 reverse([],Z,Z).
 reverse([H|T],Z,Acc):- reverse(T,Z,[H|Acc]).
 
// Remove all the occurences of an element Elt from a list
removeFrom(Elt,[],[]).
removeFrom(Elt,[Elt|ListTail],ReturnList):-
  removeFrom(Elt,ListTail,ReturnList).
removeFrom(Elt,[NotElt|ListTail],[NotElt|ReturnList]):-
  removeFrom(Elt,ListTail,ReturnList).

/* Exploration of the tree of all possible explanations */
// Predicate exploreExplanation/4
// - The first argument is a behavior (i.e. a list of dated actions)
// - The second argument is the current explanation (i.e. a set of dated 
//   actions associated with plans, the path in the tree of exploration)
// - The third argument is the list of valid explanations (returned)
// - The fourth argument is the list of plans to explore for this node.
 
// Leaf reached : the current explanation is valid
exploreExplanations([], CurrentPartialExplanation, [CurrentPartialExplanation], _).

// Running out of plans : their is no more explanations
exploreExplanations(_, _, [],[]).
 
// If the first action is explainable with the first plan, and they are other plans and this is not he last action of the behavior
exploreExplanations([[Action,Time]|BehaviorT], CurrentPartialExplanation, ValidExplanations, [Plan|PlansTail]):-
  isOKwith([[[Action,Time],Plan]|CurrentPartialExplanation]) 
  & listOfIntendableGoals(PlanTrees)
  & exploreExplanations(BehaviorT, [[[Action,Time],Plan]|CurrentPartialExplanation],ExpFromDepth, PlanTrees) // explore in depth
  & exploreExplanations([[Action,Time]|BehaviorT], CurrentPartialExplanation, ExpFromAlternatives, PlansTail) // explore other plans
  & concat(ExpFromDepth,ExpFromAlternatives, ValidExplanations).
  
// If the node is not valid, do not explore in depth, just try another plan if any
exploreExplanations([[Action,Time]|BehaviorT], CurrentPartialExplanation, ValidExplanations, [Plan|PlansTail]):-
    exploreExplanations([[Action,Time]|BehaviorT], CurrentPartialExplanation, ValidExplanations, PlansTail). // explore other plans

isOKwith([[[Action,Time],Plan]|ExpTail]):-
  isLeafOf(Action,Plan)
  & recursiveConstraintsVerifications([[Action,Time],Plan],ExpTail).

// End condition
recursiveConstraintsVerifications(_,[]).
  
  // plan trees are different : just continue
recursiveConstraintsVerifications([[Action1,Time1],Plan1],[[[Action2,Time2],Plan2]|ExpTail]):-
  Plan1\==Plan2
  & recursiveConstraintsVerifications([[Action1,Time1],Plan1],ExpTail).
  
  // In this case with two actions from a same plan tree, we should verify the constraints
recursiveConstraintsVerifications([[Action1,Time1],Plan],[[[Action2,Time2],Plan]|ExpTail]):-
  cIsOrderConstraintRespected([[Action1,Time1],Plan],[[Action2,Time2],Plan]) // check order constraints
  & areExclusionConstraintsRespected([[Action1,Time1],Plan],[[Action2,Time2],Plan]) // check exclusion constraints
  & recursiveConstraintsVerifications([[Action1,Time1],Plan],ExpTail). // continue with the next action

// commutativity
cIsOrderConstraintRespected([[Action1,Time1],Plan],[[Action2,Time2],Plan]):-
  isOrderConstraintRespected([[Action2,Time2],Plan],[[Action1,Time1],Plan]).
cIsOrderConstraintRespected([[Action1,Time1],Plan],[[Action2,Time2],Plan]):-
  isOrderConstraintRespected([[Action1,Time1],Plan],[[Action2,Time2],Plan]).
  
isOrderConstraintRespected([[Action1,Time1],Plan],[[Action2,Time2],Plan]):-
   Time1 > Time2
   & not orderConstraint(Action1,Action2,Plan) // verify there is no opposite constraint directly 
   & not (tIsSonOf(Action1,AA1,Plan) & orderConstraint(AA1,Action2,Plan)) 
   & not (tIsSonOf(Action2,AA2,Plan) & orderConstraint(Action1,AA2,Plan)) 
   & not (tIsSonOf(Action1,AA1,Plan) & tIsSonOf(Action2,AA2,Plan) & orderConstraint(AA1,AA2,Plan)). // The same on parent nodes

//commutativity
cExclusionConstraint(Action1,Action2,Plan):-
  exclusionConstraint(Action1,Action2,Plan).
cExclusionConstraint(Action1,Action2,Plan):-
  exclusionConstraint(Action2,Action1,Plan).

areExclusionConstraintsRespected([[Action1,_],Plan],[[Action2,_],Plan]):-
   not cExclusionConstraint(Action1,Action2,Plan)
   & not (tIsSonOf(Action1,AA1,Plan) & cExclusionConstraint(AA1,Action2,Plan)) 
   & not (tIsSonOf(Action2,AA2,Plan) & cExclusionConstraint(Action1,AA2,Plan))
   & not (tIsSonOf(Action1,AA1,Plan) & tIsSonOf(Action2,AA2,Plan) & cExclusionConstraint(AA1,AA2,Plan)
   	& not (tIsSonOf(Action1,AA12,Plan) & tIsSonOf(Action2,AA22,Plan) & tIsSonOf(AA12,AAF,Plan) & tIsSonOf(AA22,AAF,Plan) & not cExclusionConstraint(AA12,AA22,Plan))
   ).// The last line mean : the condition is respected if their is no exclusion constraint between these two nodes, without any alternative


// Returns N, the occurence number of a plan P in the plan count list of an explanation set (given as a second parameter)
getSpecificCountPlanInExplanationSet(_,[],0).
getSpecificCountPlanInExplanationSet(P,[[P,N]|_],N).
getSpecificCountPlanInExplanationSet(P,[_|T],N):- getSpecificCountPlanInExplanationSet(P,T,N).

// Returns as a third parameter a list of tuples containing the name of plans and their number 
// of occurences in the list of explanations given as firts parameter
countPlansInExplanationSet([],L1,L1).
countPlansInExplanationSet([Exp|ExpTail], L1, L3):-
	countPlansInExplanation(Exp,L1,L2)
	& countPlansInExplanationSet(ExpTail, L2, L3).

// Returns a list of [plan, number]
countPlansInExplanation([],L1,L1).
countPlansInExplanation([[[_,_],P]|ExpTail],L1,L2):-
	increaseCounterInPlanList(P,L1,L12)
	& countPlansInExplanation(ExpTail,L12,L2).
	
// Increase a counter in the plan list L1 and returns it as L2
increaseCounterInPlanList(P,[],[[P,1]]).
increaseCounterInPlanList(P,[[P,N]|L1],[[P,N2]|L1]):- N2=N+1.
increaseCounterInPlanList(P,[[P2,N]|L1],[[P2,N]|L2]):-
  increaseCounterInPlanList(P,L1,L2).

// Returns P the most probablePlan from the plan count list of an explanation set (given as a first parameter)
mostProbablePlan(L,P):- searchMostProbablePlan(L,P,_).
  
searchMostProbablePlan([],errorEmptyList,0).
searchMostProbablePlan([[P,N]|T],P,N):-
  searchMostProbablePlan(T,P1,N1)
  & N>N1.
searchMostProbablePlan([[P1,N1]|T],P,N):-
searchMostProbablePlan(T,P,N)
  & N>=N1.
  
  
 // TODO make that more generic  haveCoffeeBreak,haveSnack,improveSOTA
getEntropyOfBehavior(H,Behavior):-
  listOfIntendableGoals(IGs)
  & exploreExplanations(Behavior, [],Exp, IGs)
  & countPlansInExplanationSet(Exp,[],PlansNumbersList)
  & searchMostProbablePlan(PlansNumbersList,P,N)
  & getSpecificCountPlanInExplanationSet(haveCoffeeBreak,PlansNumbersList,NofHaveCoffeeBreak)
  & getSpecificCountPlanInExplanationSet(haveSnack,PlansNumbersList,NofHaveSnack)
  & getSpecificCountPlanInExplanationSet(improveSOTA,PlansNumbersList,NofImproveSOTA)
  & jia.shannonEntropy(H,NofHaveCoffeeBreak,NofHaveSnack,NofImproveSOTA).

getTestEntropyOfBehavior(H,Behavior,NofGetNuclearWeapon,NofProduceNuclearEnergy,NofProduceTechnetium):-
  listOfIntendableGoals(IGs)
  & exploreExplanations(Behavior, [],Exp, IGs)
  & countPlansInExplanationSet(Exp,[],PlansNumbersList)
  & searchMostProbablePlan(PlansNumbersList,P,N)
  & getSpecificCountPlanInExplanationSet(haveCoffeeBreak,PlansNumbersList,NofHaveCoffeeBreak)
  & getSpecificCountPlanInExplanationSet(haveSnack,PlansNumbersList,NofHaveSnack)
  & getSpecificCountPlanInExplanationSet(improveSOTA,PlansNumbersList,NofImproveSOTA)
  & jia.shannonEntropy(H,NofHaveCoffeeBreak,NofHaveSnack,NofImproveSOTA).

contains([A],A).   
contains([A|_],A).
contains([A|T],B):-contains(T,B).

// Returns L2 the list of all the sons of the node Node of plantree Tree 
// which are not already in L1
getSonsOf(Node,L,L,Tree):- not (isSonOf(Son,Node,Tree) & not contains(L,Son)).   
getSonsOf(Node,L1,L2,Tree):- isSonOf(Son,Node,Tree) & not contains(L1,Son) & getSonsOf(Node,[Son|L1],L2,Tree).
   
// Returns L2 the list of all the leaves of the subtree with the root node Node 
// of plantree Tree which are not already in L1
getLeavesOf(Node,L,L,Tree):- not (leaf(Son,_) & tIsSonOf(Son,Node,Tree) & not contains(L,Son)).   
getLeavesOf(Node,L1,L2,Tree):- leaf(Son,_) & tIsSonOf(Son,Node,Tree) & not contains(L1,Son) & getLeavesOf(Node,[Son|L1],L2,Tree).
     
// Add actions with dates to Behavior through NewBehavior
// Arguments are :
//   - the starting time of the new actions
//   - the list of actions to add
//   - the existing behavior
//   - the new behavior
addActionsToBehavior(_,[],Behavior,Behavior).
addActionsToBehavior(T,[Action|ActionsTail],Behavior,NewBehavior):-
  baseWaitingTime(TtoWait)
  & T2=T+TtoWait
  & concat(Behavior,[[Action,T]],NB)
  & addActionsToBehavior(T2,ActionsTail,NB,NewBehavior).
  
// Order a set of actions in a subtree according with constraints
 // extractUranium,enrichLessThan20p,buildLightWaterReactor,buildCentrifuge,exploitLightWaterReactor
sortByConstraints(_,_,[],[]).
sortByConstraints(_,_,[A],[A]).
sortByConstraints(Tree,Subtree,ActionList,[ResultH|ResultT]):-
  contains(ActionList,ResultH)
  & not (contains(ActionList,Action1) & orderConstraint(Action1,ResultH,Tree)) 
  & not (contains(ActionList,Action1) & tIsSonOf(AA1,Subtree,Tree) & tIsSonOf(Action1,AA1,Tree) & orderConstraint(AA1,ResultH,Tree)) 
  & not (contains(ActionList,Action1) & tIsSonOf(AA2,Subtree,Tree) & tIsSonOf(ResultH,AA2,Tree) & orderConstraint(Action1,AA2,Tree)) 
  & not (contains(ActionList,Action1) & tIsSonOf(AA1,Subtree,Tree) & tIsSonOf(Action1,AA1,Tree) & tIsSonOf(AA2,Subtree,Tree) & tIsSonOf(ResultH,AA2,Subtree) & orderConstraint(AA1,AA2,Tree)) // The same on parent nodes
  & removeFrom(ResultH,ActionList,DiminishedActionList)
  & sortByConstraints(Tree,Subtree,DiminishedActionList,ResultT).
  
giveBestRegardingH(Option1,H,Option2,H2,OptionsTail,Time,Tree,Behavior,[giveBest2|Test]):-
  maximizeEntropy(Option2,Time,H2,OptionsTail,Tree,Behavior,Test)
  & .max([H,H2],H2). 
  
giveBestRegardingH(Option1,H,Option1,H,OptionsTail,Time,Tree,Behavior,[giveBest1|Test]):-
  maximizeEntropy(_,Time,H2,OptionsTail,Tree,Behavior,Test)
  & .max([H,H2],H).

makeEntropyList(_,[],_,_,[]).
makeEntropyList(Time,[Option],Tree,Behavior,[[Option,H]]):-
  not leaf(Option,_)
  & getLeavesOf(Option,[],LtSons,Tree) // TODO: explore the maximal entropy subtree. Both in case of AND-nodes and OR-nodes. This is for debug purpose only
  & sortByConstraints(Tree,Option,LtSons,OrederedLtSons)
  & addActionsToBehavior(Time,OrederedLtSons,Behavior,NewBehavior)
  & getEntropyOfBehavior(H,NewBehavior).
  
makeEntropyList(Time,[Option|OptionsTail],Tree,Behavior,[[Option,H]|Tail]):-
  leaf(Option,_)
  & getEntropyOfBehavior(H,[[Option,Time]|Behavior])
  & makeEntropyList(Time,OptionsTail,Tree,Behavior,Tail).
  
makeEntropyList(Time,[Option|OptionsTail],Tree,Behavior,[[Option,H]|Tail]):-
  not leaf(Option,_)
  & getLeavesOf(Option,[],LtSons,Tree) // TODO: explore the maximal entropy subtree. Both in case of AND-nodes and OR-nodes. This is for debug purpose only
  //& reverse(LtSons,OrederedLtSons,[]) // TODO : verify the order constraints instead
  & sortByConstraints(Tree,Option,LtSons,OrederedLtSons)
  & addActionsToBehavior(Time,OrederedLtSons,Behavior,NewBehavior)
  & getEntropyOfBehavior(H,NewBehavior)
  & makeEntropyList(Time,OptionsTail,Tree,Behavior,Tail).
 
pickTheMostObfuscatingOptionIn([[LonelyOption,AssociateEntropy]],LonelyOption,AssociateEntropy).
pickTheMostObfuscatingOptionIn([[HeadOption,HeadEntropy]|TailOptions],BestInTail,BestEntropyInTail):-
  pickTheMostObfuscatingOptionIn(TailOptions,BestInTail,BestEntropyInTail)
  & BestEntropyInTail > HeadEntropy.
pickTheMostObfuscatingOptionIn([[HeadOption,HeadEntropy]|_],HeadOption,HeadEntropy).

pickTheLeastObfuscatingOptionIn([[LonelyOption,AssociateEntropy]],LonelyOption,AssociateEntropy).
pickTheLeastObfuscatingOptionIn([[HeadOption,HeadEntropy]|TailOptions],BestInTail,BestEntropyInTail):-
  pickTheLeastObfuscatingOptionIn(TailOptions,BestInTail,BestEntropyInTail)
  & BestEntropyInTail < HeadEntropy.
pickTheLeastObfuscatingOptionIn([[HeadOption,HeadEntropy]|_],HeadOption,HeadEntropy).
  
  