set encoding utf8
set terminal pdf size 20cm, 10cm
set output "entropyCoffee.pdf"

set title "Average entropy evolution"
set xlabel "Micro-seconds"
set ylabel "Entropy"

set yrange [0.5:2]
set xrange [9000:26000]

plot 'result.csv' using 1:9:39 with filledcurves title 'randomCoffee' lw 2 lc rgb "#CCCCFF",\
     'result.csv' using 1:9 with linespoints title 'obfuscatorCoffee' lw 2 pt "▲" lc rgb "#0000FF" tc rgb "#0000FF",\
     'result.csv' using 1:24 with lines title 'randomCoffee - average' lw 2 lc rgb "#6666FF" dt 2,\
     'result.csv' using 1:39 with linespoints title 'transparentCoffee' lw 2 pt "▼" lc rgb "#0000FF" tc rgb "#0000FF"
