set encoding utf8
set terminal pdf size 20cm, 10cm
set output "entropy.pdf"

set title "Average entropy evolution"
set xlabel "Micro-seconds"
set ylabel "Entropy"

set yrange [0.5:2]
set xrange [9000:26000]

plot 'result.csv' using 1:9 with linespoints title 'obfuscatorCoffee' lw 2 pt "▲" lc rgb "#FF0000" tc rgb "#FF0000",\
     'result.csv' using 1:24 with lines title 'randomCoffee - average' lw 2 lc rgb "#FF6666" dt 2,\
     'result.csv' using 1:4 with linespoints title 'obfuscatorBook' lw 2 pt "▲" lc rgb "#0000FF" tc rgb "#0000FF",\
     'result.csv' using 1:19 with lines title 'randomBook - average' lw 2 lc rgb "#6666FF" dt 2,\
     'result.csv' using 1:14 with linespoints title 'obfuscatorSnack' lw 2 pt "▲" lc rgb "#00FF00" tc rgb "#00FF00",\
     'result.csv' using 1:29 with lines title 'randomSnack - average' lw 2 lc rgb "#66FF66" dt 2,\
     'result.csv' using 1:39 with linespoints title 'transparentCoffee' lw 2 pt "▼" lc rgb "#FF0000" tc rgb "#FF0000",\
     'result.csv' using 1:44 with linespoints title 'transparentSnack' lw 2 pt "▼" lc rgb "#00FF00" tc rgb "#00FF00",\
     'result.csv' using 1:34 with linespoints title 'transparentBook' lw 2 pt "▼" lc rgb "#0000FF" tc rgb "#0000FF"
