#!/bin/bash

######################################################################
#
# Nicolas Cointe
#   date : december 18th 2018
#   usage : postprocess.sh [NUMBER_OF_RUNS]
#   goal : analyse data from the obfuscation proof of concept
#
######################################################################
                   
PROGRESS_BAR_LENGTH=20

# This function display an ascii progress bar
displayState()
{
  tput civis      -- invisible # Hide cursor
  echo -en " $1\t/$2\t$SECONDS s\t ["
  
  RATIO=$(echo "$1/$2" | bc -l)           # Evaluate the progress
  
  TIME_ESTIMATION=$(echo "$SECONDS/$RATIO" | bc -l )
  E_TIME_ESTIMATION=${TIME_ESTIMATION%.*} # Convert float to int

  NOW_H=$(date "+%-H")
  NOW_M=$(date "+%-M")
  NOW_S=$(date "+%-S")
  REMAIN_TIME=$(($E_TIME_ESTIMATION-$SECONDS)) 
 

  S_ESTIMATION=$(( ($REMAIN_TIME + $NOW_S) % 60 ))
  PROPAGATE=$(( ($REMAIN_TIME + $NOW_S) - $S_ESTIMATION ))
  M_ESTIMATION=$(( ($NOW_M + $PROPAGATE/60 ) %60 ))
  PROPAGATE=$(( ($NOW_M + $PROPAGATE/60 ) - $M_ESTIMATION))
  H_ESTIMATION=$(( ($NOW_H + $PROPAGATE/60 ) %24 ))

  for I in `seq 0 $PROGRESS_BAR_LENGTH`; do 

    CURSOR=$(echo "$I/$PROGRESS_BAR_LENGTH" | bc -l)
    LOWER=$(echo "$CURSOR<$RATIO" | bc -l) 
  
    if [ $LOWER -eq "1" ]; then
      echo -n "#"
    else
      echo -n "-"
    fi
  done

  echo -en "] Estimated end : $H_ESTIMATION h $M_ESTIMATION m $S_ESTIMATION s \r"
  tput cnorm   -- normal       # Restore the cursor visibility
}

if [[ $# != 0 ]]
  then
    NUM_OF_RUNS=$1
  else
    NUM_OF_RUNS=$(( `ls -l out | grep -c ^d` ))
fi

for i in `seq 1 $NUM_OF_RUNS`
	do
    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=randomCoffee" | sed -e 's/haveCoffeeBreak/true/g' | sed -e 's/haveSnack\|improveSOTA/false/g' | sed -e 's/\[onlooker\] Agent=randomCoffee T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/randomCoffee.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=randomSnack" | sed -e 's/haveSnack/true/g' | sed -e 's/haveCoffeeBreak\|improveSOTA/false/g' | sed -e 's/\[onlooker\] Agent=randomSnack T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/randomSnack.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=randomBook" | sed -e 's/improveSOTA/true/g' | sed -e 's/haveCoffeeBreak\|haveSnack/false/g' | sed -e 's/\[onlooker\] Agent=randomBook T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/randomBook.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=obfuscatorCoffee" | sed -e 's/haveCoffeeBreak/true/g' | sed -e 's/haveSnack\|improveSOTA/false/g' | sed -e 's/\[onlooker\] Agent=obfuscatorCoffee T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/obfuscatorCoffee.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=obfuscatorSnack" | sed -e 's/haveSnack/true/g' | sed -e 's/haveCoffeeBreak\|improveSOTA/false/g' | sed -e 's/\[onlooker\] Agent=obfuscatorSnack T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/obfuscatorSnack.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=obfuscatorBook" | sed -e 's/improveSOTA/true/g' | sed -e 's/haveCoffeeBreak\|haveSnack/false/g' | sed -e 's/\[onlooker\] Agent=obfuscatorBook T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/obfuscatorBook.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=transparentCoffee" | sed -e 's/haveCoffeeBreak/true/g' | sed -e 's/haveSnack\|improveSOTA/false/g' | sed -e 's/\[onlooker\] Agent=transparentCoffee T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/transparentCoffee.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=transparentSnack" | sed -e 's/haveSnack/true/g' | sed -e 's/haveCoffeeBreak\|improveSOTA/false/g' | sed -e 's/\[onlooker\] Agent=transparentSnack T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/transparentSnack.txt

    cat out/$i/log.txt | grep -e "\[onlooker\] Agent=transparentBook" | sed -e 's/improveSOTA/true/g' | sed -e 's/haveCoffeeBreak\|haveSnack/false/g' | sed -e 's/\[onlooker\] Agent=transparentBook T=\|MPG=\|Entropy=\|([^)]*)//g' > out/$i/transparentBook.txt

    displayState $i $NUM_OF_RUNS
done


./dp $NUM_OF_RUNS | sed -e 's/0.000000/NaN/g' | sed -e 's/transparentCoffee\|transparentSnack\|transparentBook\|obfuscatorCoffee\|obfuscatorSnack\|obfuscatorBook\|randomCoffee\|randomSnack\|randomBook//g' > result.csv
#./dp $NUM_OF_RUNS | sed -e 's/0.000000/NaN/g' > result.csv

echo ""
echo "Final results generated"

gnuplot showEntropy.plot
gnuplot showEntropyCoffee.plot

echo -e "\nPostprocessing is done"






