#include <cstdlib>
#include <iostream>
#include <fstream>
#include <ios>
#include <bits/ios_base.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>

#include "DataSet.h"

int main(int argc, char** argv)
{
  if(argc!=2)
  {
    std::cout << "Usage : " << argv[0] << " [number of runs]";
    return EXIT_FAILURE;
  }
  int number_of_runs = std::atoi(argv[1]);

  DataSet ds;
  std::vector<std::string> namesOfAgents;
  namesOfAgents.push_back("transparentCoffee");
  namesOfAgents.push_back("transparentSnack");
  namesOfAgents.push_back("transparentBook");
  namesOfAgents.push_back("obfuscatorCoffee");
  namesOfAgents.push_back("obfuscatorSnack");
  namesOfAgents.push_back("obfuscatorBook");
  namesOfAgents.push_back("randomCoffee");
  namesOfAgents.push_back("randomSnack");
  namesOfAgents.push_back("randomBook");

  // Reading from files
  for(int i=1; i<=number_of_runs; i++)
  {
    for(int a=0; a<namesOfAgents.size(); a++)
    {
      std::string nameOfFile = "./out/";
      char lineBuffer[256];
      nameOfFile+=std::to_string(i);
      nameOfFile+="/";
      nameOfFile+=namesOfAgents.at(a);
      nameOfFile+=".txt";

      std::ifstream ifs (nameOfFile.c_str(), std::ifstream::in);
      ifs.getline(lineBuffer,256);
      std::string lineString = lineBuffer;

      while (ifs.good()) {
        ds.insertLine(namesOfAgents.at(a),lineString);
        ifs.getline(lineBuffer,256);
        lineString = lineBuffer;
      }

      ifs.close();
    }
  }

  ds.fill(namesOfAgents);

  std::cout << ds.print();
  return EXIT_SUCCESS;
}
