//
// Created by nicolas on 18/12/18.
//

#include "DataSet.h"

#include <iostream>

DataSet::DataSet():
  _data(new std::map<int,std::map<std::string,std::array<float,5>>>())
{

}

void DataSet::insertLine(std::string agentName, std::string line)
{
  //std::cout<<line<<std::endl;

  int time=atoi(line.substr(0,line.find_first_of(' ')).c_str());
  line=line.substr(line.find_first_of(' ')+1);
  std::string identified=line.substr(0,line.find_first_of(' ')).c_str();
  line=line.substr(line.find_first_of(' ')+1);
  float entropy = atof(line.c_str());
  time=time-time%PRECISION;
  //std::cout << "line '" << time << "' identified '" << identified << "' entropy '" << entropy << "'"<< std::endl;

  std::map<int,std::map<std::string,std::array<float,5>>>::iterator itData=_data->find(time);
  if(itData!= _data->end())
  {
    std::map<std::string,std::array<float,5>>::iterator itAgentMap=itData->second.find(agentName);
    if(itAgentMap!=itData->second.end())
    {
      //update proportion of true answers
      if(identified=="true")
        itAgentMap->second[1]=(itAgentMap->second[1]*itAgentMap->second[0]+1.0)/(itAgentMap->second[0]+1);
      else
        itAgentMap->second[1]=itAgentMap->second[1]*itAgentMap->second[0]/(itAgentMap->second[0]+1);

      //update the average entropy
      itAgentMap->second[2]=(itAgentMap->second[2]*itAgentMap->second[0]+entropy)/(itAgentMap->second[0]+1);

      //update the minimum and maximum
      if(entropy<itAgentMap->second[3]) itAgentMap->second[3]=entropy;
      if(entropy>itAgentMap->second[4]) itAgentMap->second[4]=entropy;

      itAgentMap->second[0]+=1.0;
    }
    else
    {
      std::map<std::string,std::array<float,5>> agentMap;
      std::array<float,5> values;
      values[0]=1.0;
      if(identified=="true") values[1]=1.0;
      else values[1]=0.0;
      values[2]=entropy;
      values[3]=entropy;
      values[4]=entropy;
      itData->second.insert(std::pair<std::string,std::array<float,5>>(agentName,values));
    }
  }
  else
  {
    std::map<std::string,std::array<float,5>> agentMap;
    std::array<float,5> values;
    values[0]=1.0;
    if(identified=="true") values[1]=1.0;
    else values[1]=0.0;
    values[2]=entropy;
    values[3]=entropy;
    values[4]=entropy;
    agentMap.insert(std::pair<std::string,std::array<float,5>>(agentName,values));
    _data->insert(std::pair<int,std::map<std::string,std::array<float,5>>>(time,agentMap));
  }
}

std::string DataSet::print()
{
  std::string answer;
  for (std::map<int,std::map<std::string,std::array<float,5>>>::iterator itData =_data->begin(); itData!=_data->end() ; itData++)
  {
    answer+=std::to_string(itData->first);
    for(std::map<std::string,std::array<float,5>>::iterator itAgentMap = itData->second.begin(); itAgentMap!=itData->second.end(); itAgentMap++)
    {
      answer+=" ";
      answer+=itAgentMap->first;
      answer+=" ";
      answer+=std::to_string((int)itAgentMap->second[0]);
      answer+=" ";
      answer+=std::to_string(itAgentMap->second[1]);
      answer+=" ";
      answer+=std::to_string(itAgentMap->second[2]);
      answer+=" ";
      answer+=std::to_string(itAgentMap->second[3]);
      answer+=" ";
      answer+=std::to_string(itAgentMap->second[4]);
    }
    answer+="\n";
  }
  return answer;
}

void DataSet::fill(std::vector<std::string> namesOfAgents)
{
  for (std::map<int,std::map<std::string,std::array<float,5>>>::iterator itData =_data->begin(); itData!=_data->end() ; itData++)
  {
    for (std::vector<std::string>::iterator itNames = namesOfAgents.begin(); itNames != namesOfAgents.end() ; itNames++)
    {
      if(itData->second.find(*itNames)==itData->second.end())
      {
        std::array<float, 5> values;
        values[0] = 0.0;
        values[1] = 0.0;
        values[2] = 0.0;
        values[3] = 0.0;
        values[4] = 0.0;
        itData->second.insert(std::pair<std::string,std::array<float,5>>(*itNames,values));
      }
    }
  }
}

