/*
 * Decompiled with CFR 0.152.
 */
package jacamo.util;

import jacamo.util.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreateNewProject {
    File main;
    File path;
    String id;
    static Config c = Config.get();

    public CreateNewProject(File m) {
        this.main = m;
        this.path = this.main.getAbsoluteFile();
        this.id = this.main.getName();
        this.id = this.id.substring(0, 1).toLowerCase() + this.id.substring(1);
        this.id = this.id.replace("-", "_");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println(Config.get().getPresentation() + "\n");
            System.out.println("usage must be:");
            System.out.println("      java " + CreateNewProject.class.getName() + " <id of new application>");
            return;
        }
        CreateNewProject p = new CreateNewProject(new File(args[0]));
        p.createDirs();
        p.copyFiles();
        p.usage();
    }

    void usage() {
        System.out.println("\n\nYou can run your application with:");
        System.out.println("   $ jacamo " + this.path + "/" + this.id + ".jcm");
        System.out.println("or");
        System.out.println("   $ cd " + this.path);
        System.out.println("   $ gradle -q\n");
        System.out.println("an eclipse project can be created with");
        System.out.println("   $ gradle eclipse\n");
    }

    void createDirs() {
        if (!this.path.exists()) {
            System.out.println("Creating path " + this.path);
            this.path.mkdirs();
        }
        new File(this.path + "/doc").mkdirs();
        new File(this.path + "/lib").mkdirs();
        new File(this.path + "/log").mkdirs();
        new File(this.path + "/src/agt/inc").mkdirs();
        new File(this.path + "/src/agt/jia").mkdirs();
        new File(this.path + "/src/env/tools").mkdirs();
        new File(this.path + "/src/org").mkdirs();
        new File(this.path + "/src/int").mkdirs();
    }

    void copyFiles() {
        this.copyFile("project", new File(this.path + "/" + this.id + ".jcm"));
        this.copyFile("agent", new File(this.path + "/src/agt/sample_agent.asl"));
        this.copyFile("logging.properties", new File(this.path + "/logging.properties"));
        this.copyFile("CArtAgOartifact", new File(this.path + "/src/env/tools/Counter.java"));
        this.copyFile("organization", new File(this.path + "/src/org/org.xml"));
        this.copyFile("build.gradle", new File(this.path + "/build.gradle"));
    }

    void copyFile(String source, File target) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(c.getDetaultResource(source)));
            BufferedWriter out = new BufferedWriter(new FileWriter(target));
            String l = in.readLine();
            while (l != null) {
                l = l.replace("<PROJECT_NAME>", this.id);
                l = l.replace("<PLATFORM>", "");
                l = l.replace("<PROJECT-FILE>", this.id + ".jcm");
                l = l.replace("<VERSION>", c.getJaCaMoVersion());
                l = l.replace("<DATE>", new SimpleDateFormat("MMMM dd, yyyy - HH:mm:ss").format(new Date()));
                l = l.replace("<DEFAULT_AGENT>", "agent sample_agent");
                l = l.replace("<AG_NAME>", "sample_agent");
                l = l.replace("<PCK>", "tools");
                l = l.replace("<ARTIFACT_NAME>", "Counter");
                l = l.replace("<SUPER_CLASS>", "Artifact");
                l = l.replace("<ORGANIZATION_NAME>", this.id);
                l = l.replace("handlers = jason.runtime.MASConsoleLogHandler", "#handlers = jason.runtime.MASConsoleLogHandler");
                l = l.replace("#handlers= java.util.logging.ConsoleHandler", "handlers= java.util.logging.ConsoleHandler");
                out.append(l + "\n");
                l = in.readLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

