/*
 * Decompiled with CFR 0.152.
 */
package jacamo.util;

import jacamo.util.Config;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ConfigGUI {
    protected JTextField jacamoTF;
    protected JTextField javaTF;
    protected JTextField dotTF;
    protected String initJacamoHome = null;
    protected static Config userProperties = Config.get();

    public static void main(String[] args) {
        new ConfigGUI().run();
    }

    protected static ConfigGUI getNewInstance() {
        return new ConfigGUI();
    }

    public void run() {
        userProperties.resetSomeProps();
        userProperties.fix();
        final ConfigGUI jid = ConfigGUI.getNewInstance();
        JFrame f = null;
        try {
            f = new JFrame(jid.getWindowTitle());
        }
        catch (Exception e) {
            userProperties.store();
            System.out.println("\nYou can edit the file " + userProperties.getUserConfFile() + " for your local configuration.");
            return;
        }
        f.setDefaultCloseOperation(3);
        JPanel pBt = new JPanel(new FlowLayout());
        JButton bQuit = new JButton("Exit without saving");
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
        pBt.add(bQuit);
        JButton bSave = new JButton("Save configuration and Exit");
        bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                jid.save();
                System.exit(0);
            }
        });
        pBt.add(bSave);
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", jid.getJasonConfigPanel());
        p.add("South", pBt);
        f.getContentPane().add(p);
        f.pack();
        f.setVisible(true);
    }

    protected String getWindowTitle() {
        return "JaCaMo Configuration -- " + userProperties.getJaCaMoVersion();
    }

    public JPanel getJasonConfigPanel() {
        JPanel pop = new JPanel();
        pop.setLayout(new BoxLayout(pop, 1));
        this.jacamoTF = new JTextField(35);
        JPanel jacamoHomePanel = new JPanel(new GridLayout(0, 1));
        jacamoHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JaCaMo", 1, 2));
        JPanel jacamoJarPanel = new JPanel(new FlowLayout(0));
        jacamoJarPanel.add(new JLabel("jacamo.jar location"));
        jacamoJarPanel.add(this.jacamoTF);
        jacamoJarPanel.add(this.createBrowseButton("jacamo.jar", this.jacamoTF));
        jacamoHomePanel.add(jacamoJarPanel);
        pop.add(jacamoHomePanel);
        JPanel javaHomePanel = new JPanel();
        javaHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Java Home", 1, 2));
        javaHomePanel.setLayout(new FlowLayout(0));
        javaHomePanel.add(new JLabel("Directory"));
        this.javaTF = new JTextField(35);
        javaHomePanel.add(this.javaTF);
        JButton setJava = new JButton("Browse");
        setJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.setDialogTitle("Select the Java JDK home directory");
                    chooser.setFileSelectionMode(1);
                    if (chooser.showOpenDialog(null) == 0) {
                        String javaHome = new File(chooser.getSelectedFile().getPath()).getCanonicalPath();
                        if (Config.checkJavaHomePath(javaHome)) {
                            ConfigGUI.this.javaTF.setText(javaHome);
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected JDK home directory doesn't have the bin/javac file!");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        javaHomePanel.add(setJava);
        pop.add(javaHomePanel);
        this.dotTF = new JTextField(35);
        this.dotTF.setToolTipText("Dot is used to produce graphical representation of the organization. It can be installed from http://www.graphviz.org.");
        JPanel dotHomePanel = new JPanel(new GridLayout(0, 1));
        dotHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "dot (optional)", 1, 2));
        JPanel dotPanel = new JPanel(new FlowLayout(0));
        dotPanel.add(new JLabel("program location"));
        dotPanel.add(this.dotTF);
        dotHomePanel.add(dotPanel);
        pop.add(dotHomePanel);
        this.initJacamoHome = userProperties.getProperty("jacamoJar");
        this.jacamoTF.setText(this.initJacamoHome);
        this.javaTF.setText(userProperties.getJavaHome());
        String v = userProperties.getDotPath();
        if (v == null) {
            v = "";
        }
        this.dotTF.setText(v);
        return pop;
    }

    protected JButton createBrowseButton(final String jarfile, final JTextField tf) {
        JButton bt = new JButton("Browse");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.setDialogTitle("Select the " + jarfile + " file");
                    chooser.setFileFilter(new JarFileFilter("The " + jarfile + " file"));
                    if (chooser.showOpenDialog(null) == 0) {
                        String selJar = new File(chooser.getSelectedFile().getPath()).getCanonicalPath();
                        if (Config.checkJar(selJar)) {
                            tf.setText(selJar);
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected " + jarfile + " file was not ok!");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return bt;
    }

    public void save() {
        File fDot;
        if (Config.checkJar(this.jacamoTF.getText())) {
            String jh = this.jacamoTF.getText().trim();
            userProperties.put("jacamoJar", jh);
            if (!jh.equals(this.initJacamoHome)) {
                userProperties.resetSomeProps();
                userProperties.fix();
            }
        }
        if (Config.checkJavaHomePath(this.javaTF.getText()) || Config.checkJREHomePath(this.javaTF.getText())) {
            userProperties.setJavaHome(this.javaTF.getText().trim());
        }
        if ((fDot = new File(this.dotTF.getText().trim())).exists()) {
            userProperties.put("dotPath", fDot.getAbsolutePath());
        } else {
            System.out.println("The dot program does not exist at " + fDot + ", ignoring the value.");
        }
        userProperties.store();
    }

    class JarFileFilter
    extends FileFilter {
        String ds;

        public JarFileFilter(String ds) {
            this.ds = ds;
        }

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith("jar") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.ds;
        }
    }
}

