/*
 * Decompiled with CFR 0.152.
 */
package jacamo.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Config
extends jason.util.Config {
    private static final long serialVersionUID = 1L;
    public static final String jacamoHomeProp = "JaCaMoHome";
    public static final String DOT_PATH = "dotPath";
    public static final String JACAMO_JAR = "jacamoJar";
    public static final String MOISE_JAR = "moiseJar";

    public static Config get() {
        return Config.get(false);
    }

    public static Config get(boolean tryToFixConfig) {
        if (singleton == null || !singleton.getClass().getName().equals(Config.class.getName())) {
            jason.util.Config.setClassFactory(Config.class.getName());
            singleton = new Config();
            if (!singleton.load() && tryToFixConfig) {
                singleton.fix();
                singleton.store();
            }
        }
        return (Config)singleton;
    }

    @Override
    public InputStream getDetaultResource(String templateName) throws IOException {
        return new URL("jar:file:" + this.getJaCaMoJar() + "!/templates/" + templateName).openStream();
    }

    @Override
    protected String getHome() {
        return this.getJaCaMoHome();
    }

    @Override
    public File getUserConfFile() {
        return new File(System.getProperties().get("user.home") + File.separator + ".jacamo/user.properties");
    }

    @Override
    public File getMasterConfFile() {
        return new File("jacamo.properties");
    }

    @Override
    public String getFileConfComment() {
        return "JaCaMo user configuration";
    }

    @Override
    protected String getEclipseInstallationDirectory() {
        return "jacamo";
    }

    public String getDotPath() {
        String r = super.getProperty(DOT_PATH);
        if (r == null) {
            r = "/opt/local/bin/dot";
        }
        if (new File(r).exists()) {
            return r;
        }
        r = "/usr/bin/dot";
        if (new File(r).exists()) {
            return r;
        }
        return null;
    }

    @Override
    public String getPresentation() {
        return "JaCaMo " + this.getJaCaMoVersion() + "\n" + "     built on " + this.getJasonBuiltDate() + "\n" + "     installed at " + this.getJaCaMoHome();
    }

    public String getJaCaMoHome() {
        try {
            if (this.get(JACAMO_JAR) != null) {
                return new File(this.get(JACAMO_JAR).toString()).getParentFile().getParent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getJaCaMoJar() {
        return this.getProperty(JACAMO_JAR);
    }

    @Override
    public String getJasonJar() {
        String jj = super.getJasonJar();
        if (jj == null) {
            try {
                File jasonjardir = new File(this.getJaCaMoHome() + "/libs").getAbsoluteFile().getCanonicalFile();
                String jarFile = Config.findJarInDirectory(jasonjardir, "jason");
                if (Config.checkJar(jarFile, 800000)) {
                    this.put("jasonJar", jarFile);
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile + " by JaCaMo HOME");
                    }
                    jj = jarFile;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jj;
    }

    @Override
    public void fix() {
        this.tryToFixJarFileConf(JACAMO_JAR, "jacamo", 5000);
        this.tryToFixJarFileConf(MOISE_JAR, "moise", 5000);
        super.fix();
        if (this.getProperty("startWebEnvInspector") == null) {
            this.put("startWebEnvInspector", "true");
        }
        if (this.getProperty("startWebOrgInspector") == null) {
            this.put("startWebOrgInspector", "true");
        }
        if (this.get("antLib") == null || !Config.checkAntLib(this.getAntLib())) {
            try {
                String antlib;
                String jjar = this.getJaCaMoHome();
                if (jjar != null && Config.checkAntLib(antlib = jjar + File.separator + "libs")) {
                    this.setAntLib(antlib);
                }
            }
            catch (Exception e) {
                System.out.println("Error setting ant lib!");
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getAntLib() {
        String al = super.getAntLib();
        if (al == null) {
            return this.getJaCaMoHome() + "/libs";
        }
        return al;
    }

    public String getJaCaMoVersion() {
        Package j = Package.getPackage("jacamo.util");
        if (j != null) {
            return j.getSpecificationVersion();
        }
        return "?";
    }

    public static void main(String[] args) {
        Config.get().fix();
        Config.get().store();
    }

    static {
        jason.util.Config.setClassFactory(Config.class.getName());
    }
}

