/*
 * Decompiled with CFR 0.152.
 */
package jacamo.project;

import jacamo.project.JaCaMoAgentParameters;
import jacamo.project.JaCaMoProject;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import java.util.HashMap;
import java.util.Map;

public class JaCaMoWorkspaceParameters {
    protected JaCaMoProject project;
    protected String name;
    protected String node;
    protected Map<String, ClassParameters> artifacts = new HashMap<String, ClassParameters>();
    protected boolean debug = false;

    public JaCaMoWorkspaceParameters(JaCaMoProject project) {
        this.project = project;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setNode(String h) {
        this.node = h;
    }

    public String getNode() {
        return this.node;
    }

    public void addArtifact(String name, ClassParameters className) {
        this.artifacts.put(name, className);
    }

    public Map<String, ClassParameters> getArtifacts() {
        return this.artifacts;
    }

    public ClassParameters getArtifact(String artId) {
        return this.artifacts.get(artId);
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public boolean hasDebug() {
        return this.debug;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("   workspace " + this.name + " {\n");
        for (String a : this.artifacts.keySet()) {
            s.append("      artifact " + a + ": " + this.artifacts.get(a) + "\n");
        }
        String bgn = "      agents: ";
        for (AgentParameters ap : this.project.getAgents()) {
            JaCaMoAgentParameters jap = (JaCaMoAgentParameters)ap;
            for (String w : jap.getWorkspaces()) {
                if (!w.equals(this.name)) continue;
                s.append(bgn + ap.getAgName());
                bgn = ", ";
            }
        }
        s.append("\n");
        if (this.getNode() != null) {
            s.append("      node: " + this.getNode() + "\n");
        }
        if (this.hasDebug()) {
            s.append("\n      debug\n");
        }
        s.append("   }");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JaCaMoWorkspaceParameters)) {
            return false;
        }
        return this.name.equals(((JaCaMoWorkspaceParameters)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

