/*
 * Decompiled with CFR 0.152.
 */
package jacamo.project;

import jacamo.infra.JaCaMoInfrastructureFactory;
import jacamo.project.JaCaMoAgentParameters;
import jacamo.project.JaCaMoGroupParameters;
import jacamo.project.JaCaMoOrgParameters;
import jacamo.project.JaCaMoWorkspaceParameters;
import jacamo.project.parser.JaCaMoProjectParser;
import jacamo.project.parser.ParseException;
import jason.JasonException;
import jason.infra.InfrastructureFactory;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.runtime.SourcePath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class JaCaMoProject
extends MAS2JProject {
    protected static Logger logger = Logger.getLogger(JaCaMoProject.class.getName());
    protected Map<String, JaCaMoWorkspaceParameters> workspaces = new HashMap<String, JaCaMoWorkspaceParameters>();
    protected List<JaCaMoOrgParameters> orgs = new ArrayList<JaCaMoOrgParameters>();
    protected Set<String> deplNodes = new HashSet<String>();
    protected Map<String, String> nodeHosts = new HashMap<String, String>();
    protected SourcePath orgPaths = new SourcePath();
    protected SourcePath javaPaths = new SourcePath();
    Map<String, String[]> platformParameters = new HashMap<String, String[]>();

    public JaCaMoProject() {
        this.addSourcePath(".");
        this.addSourcePath("src/agt");
        this.addSourcePath("src/agt/inc");
        this.addClassPath("lib");
        this.orgPaths.addPath(".");
        this.orgPaths.addPath("src/org");
        this.javaPaths.addPath(".");
        this.javaPaths.addPath("src/env");
        this.javaPaths.addPath("src/agt");
    }

    public JaCaMoProject(MAS2JProject project) {
        this();
        this.setSocName(project.getSocName());
        this.setProjectFile(project.getProjectFile());
        this.setDirectory(project.getDirectory());
        this.importProject(project);
    }

    public SourcePath getOrgPaths() {
        return this.orgPaths;
    }

    public void addOrgSourcePath(String s) {
        this.orgPaths.addPath(s);
    }

    public SourcePath getJavaPaths() {
        return this.javaPaths;
    }

    public void addJavaSourcePath(String s) {
        this.javaPaths.addPath(s);
    }

    public void setUrlPrefix(String url) {
        this.orgPaths.setUrlPrefix(url);
        super.getSourcePaths().setUrlPrefix(url);
    }

    public void importProject(String directory, File f) throws ParseException {
        try {
            if (!f.toString().endsWith(".jcm")) {
                f = new File(f + ".jcm");
            }
            if (!f.exists()) {
                f = new File(directory + "/" + f.toString());
            }
            JaCaMoProjectParser parser = new JaCaMoProjectParser(new FileReader(f.getAbsolutePath()));
            this.importProject(parser.parse(directory));
        }
        catch (ParseException e) {
            throw new ParseException("Error parsing included file " + f + "!\n" + e);
        }
        catch (FileNotFoundException e) {
            throw new ParseException("File not found " + f.getAbsolutePath() + "\n" + e);
        }
    }

    public void importProject(MAS2JProject project) {
        this.getSourcePaths().addAll(project.getSourcePaths());
        for (String string : project.getClassPaths()) {
            this.addClassPath(string);
        }
        if (project instanceof JaCaMoProject) {
            JaCaMoProject jproject = (JaCaMoProject)project;
            for (AgentParameters a : project.getAgents()) {
                this.addAgent(a);
                ((JaCaMoAgentParameters)a).setProject(this);
            }
            for (JaCaMoOrgParameters o : jproject.orgs) {
                this.addOrg(o);
            }
            for (JaCaMoWorkspaceParameters w : jproject.workspaces.values()) {
                if (this.getOrg(w.getName()) != null) continue;
                this.addWorkspace(w);
            }
            this.deplNodes.addAll(jproject.deplNodes);
            this.nodeHosts.putAll(jproject.nodeHosts);
            this.platformParameters.putAll(jproject.platformParameters);
        } else {
            for (AgentParameters agentParameters : project.getAgents()) {
                this.addAgent(new JaCaMoAgentParameters(this, agentParameters));
            }
        }
    }

    @Override
    public void setupDefault() {
    }

    @Override
    public InfrastructureFactory getInfrastructureFactory() throws JasonException {
        return new JaCaMoInfrastructureFactory();
    }

    @Override
    public boolean isJade() {
        return this.getPlatformParameters().keySet().contains("jade");
    }

    public void addAgFocus(String agId, String nameSpace, String artId, JaCaMoWorkspaceParameters wks) {
        if (agId.equals("*")) {
            for (AgentParameters ap : this.getAgents()) {
                JaCaMoAgentParameters jap = (JaCaMoAgentParameters)ap;
                jap.addFocus(artId, nameSpace, wks.getName(), null);
            }
        } else {
            JaCaMoAgentParameters ap = (JaCaMoAgentParameters)this.getAg(agId);
            if (ap == null) {
                logger.warning("Agent " + agId + " was not declared and so cannot focus on " + artId);
            } else {
                JaCaMoAgentParameters jap = ap;
                jap.addFocus(artId, nameSpace, wks.getName(), null);
            }
        }
    }

    public JaCaMoWorkspaceParameters getArtifactWorkspace(String artId) {
        for (JaCaMoWorkspaceParameters w : this.workspaces.values()) {
            if (w.getArtifact(artId) == null) continue;
            return w;
        }
        return null;
    }

    public JaCaMoOrgParameters getGroupOrg(String gId) {
        for (JaCaMoOrgParameters o : this.orgs) {
            if (o.getGroup(gId) == null) continue;
            return o;
        }
        return null;
    }

    public void parserFinished() {
        for (AgentParameters a : this.getAgents()) {
            ((JaCaMoAgentParameters)a).fix();
        }
    }

    public void addWorkspace(JaCaMoWorkspaceParameters w) {
        this.workspaces.put(w.getName(), w);
    }

    public Collection<JaCaMoWorkspaceParameters> getWorkspaces() {
        return this.workspaces.values();
    }

    public JaCaMoWorkspaceParameters getWorkspace(String wid) {
        JaCaMoWorkspaceParameters w = this.workspaces.get(wid);
        if (w == null) {
            for (JaCaMoOrgParameters o : this.orgs) {
                if (!o.getName().equals(wid)) continue;
                return o;
            }
        }
        return w;
    }

    public void setWorkspaceNode(String wid, String n) {
        JaCaMoWorkspaceParameters w = this.workspaces.get(wid);
        if (w == null) {
            w = new JaCaMoWorkspaceParameters(this);
            w.setName(wid);
            this.addWorkspace(w);
        }
        w.setNode(n);
    }

    public String getWorkspaceNode(String wid) {
        JaCaMoWorkspaceParameters w = this.workspaces.get(wid);
        if (w == null) {
            return null;
        }
        return w.getNode();
    }

    public String getWorkspaceHost(String wName) {
        JaCaMoWorkspaceParameters wp = this.workspaces.get(wName);
        if (wp == null || wp.getNode() == null) {
            return null;
        }
        return this.nodeHosts.get(wp.getNode());
    }

    public void addOrg(JaCaMoOrgParameters o) {
        this.orgs.add(o);
    }

    public Collection<JaCaMoOrgParameters> getOrgs() {
        return this.orgs;
    }

    public JaCaMoOrgParameters getOrg(String oid) {
        for (JaCaMoOrgParameters o : this.orgs) {
            if (!o.getName().equals(oid)) continue;
            return o;
        }
        return null;
    }

    public void addAgWorkspace(String agId, JaCaMoWorkspaceParameters w) {
        if (agId.equals("*")) {
            for (AgentParameters ap : this.getAgents()) {
                JaCaMoAgentParameters jap = (JaCaMoAgentParameters)ap;
                jap.addWorkspace(w.getName(), w.getNode());
            }
        } else {
            JaCaMoAgentParameters ap = (JaCaMoAgentParameters)this.getAg(agId);
            if (ap == null) {
                logger.warning("Agent " + agId + " was not declared and so cannot be included in workspace " + w.getName());
            } else {
                ap.addWorkspace(w.getName(), w.getNode());
            }
        }
    }

    public void addAgRole(String agId, JaCaMoOrgParameters org, JaCaMoGroupParameters group, String role) {
        JaCaMoAgentParameters ap = (JaCaMoAgentParameters)this.getAg(agId);
        if (ap == null) {
            logger.warning("Agent " + agId + " was not declared and so cannot play role " + role);
        } else {
            ap.addRole(org.getName(), group.getName(), role);
            this.addAgWorkspace(agId, org);
        }
    }

    public void resetPlatform() {
        this.platformParameters.clear();
    }

    public void addPlatformParameters(ClassParameters cp) {
        if (cp.getClassName().equals("centralised")) {
            this.setInfrastructure(cp);
        }
        this.platformParameters.put(cp.getClassName(), cp.getParametersArray());
    }

    public Map<String, String[]> getPlatformParameters() {
        return this.platformParameters;
    }

    public String[] getPlatformParameters(String p) {
        return this.platformParameters.get(p);
    }

    public boolean hasPlatformParameter(String p, String arg) {
        String[] args = this.platformParameters.get(p);
        if (args != null) {
            for (String pa : args) {
                if (!pa.contains(arg)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDeploymentNode() {
        this.deplNodes.clear();
    }

    public Collection<String> getAllCitedNodes() {
        HashSet<String> an = new HashSet<String>();
        for (AgentParameters ap : this.getAgents()) {
            if (ap.getHost() == null) continue;
            an.add(ap.getHost());
        }
        for (JaCaMoWorkspaceParameters wp : this.getWorkspaces()) {
            if (wp.getNode() == null) continue;
            an.add(wp.getNode());
        }
        for (JaCaMoOrgParameters op : this.getOrgs()) {
            if (op.getNode() == null) continue;
            an.add(op.getNode());
        }
        return an;
    }

    public Collection<String> getDeploymentNodes() {
        return this.deplNodes;
    }

    public boolean isInDeployment(String node) {
        return node == null || this.deplNodes.contains(node) || this.nodeHosts.get(node) == null;
    }

    public void resetNodeHosts() {
        this.nodeHosts.clear();
    }

    public void addNodeHost(String n, String h, boolean running) {
        if (!running) {
            this.deplNodes.add(n);
        }
        this.nodeHosts.put(n, h);
    }

    public String getNodeHost(String n) {
        return this.nodeHosts.get(n);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("/*\n");
        s.append("    JaCaMo Project\n\n");
        s.append("    -- created on " + new SimpleDateFormat("MMMM dd, yyyy").format(new Date()) + "\n");
        s.append("*/\n\n");
        s.append("mas " + this.getSocName() + " {\n\n");
        Iterator<AgentParameters> i = this.getAgents().iterator();
        while (i.hasNext()) {
            s.append("   " + i.next());
            s.append("\n");
        }
        for (JaCaMoWorkspaceParameters jaCaMoWorkspaceParameters : this.workspaces.values()) {
            s.append(jaCaMoWorkspaceParameters.toString() + "\n\n");
        }
        for (JaCaMoWorkspaceParameters jaCaMoWorkspaceParameters : this.orgs) {
            s.append(jaCaMoWorkspaceParameters.toString() + "\n\n");
        }
        String bgn = "   class-path: ";
        for (String p : this.getClassPaths()) {
            s.append(bgn + p + "\n");
            bgn = "               ";
        }
        bgn = "   asl-path:   ";
        for (String p : this.getSourcePaths().getPaths()) {
            s.append(bgn + p + "\n");
            bgn = "               ";
        }
        for (String n : this.nodeHosts.keySet()) {
            s.append("   node " + n + "@" + this.nodeHosts.get(n) + "\n");
        }
        bgn = "   platform:     ";
        for (String p : this.getPlatformParameters().keySet()) {
            s.append(bgn + p + "(");
            String v = "";
            for (String arg : this.getPlatformParameters(p)) {
                s.append(v + arg);
                v = ", ";
            }
            s.append(")\n");
            bgn = "                 ";
        }
        s.append("}");
        return s.toString();
    }
}

