/*
 * Decompiled with CFR 0.152.
 */
package jacamo.project;

import jacamo.project.JaCaMoAgentParameters;
import jacamo.project.JaCaMoGroupParameters;
import jacamo.project.JaCaMoProject;
import jacamo.project.JaCaMoSchemeParameters;
import jacamo.project.JaCaMoWorkspaceParameters;
import jason.mas2j.AgentParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JaCaMoOrgParameters
extends JaCaMoWorkspaceParameters {
    protected List<JaCaMoGroupParameters> groups = new ArrayList<JaCaMoGroupParameters>();
    protected List<JaCaMoSchemeParameters> schemes = new ArrayList<JaCaMoSchemeParameters>();
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected String debug = null;

    public JaCaMoOrgParameters(JaCaMoProject project) {
        super(project);
    }

    public void addParameter(String k, String v) {
        this.parameters.put(k, v);
    }

    public String getParameter(String k) {
        return this.parameters.get(k);
    }

    public void addGroup(JaCaMoGroupParameters g) {
        this.groups.add(g);
    }

    public List<JaCaMoGroupParameters> getGroups() {
        return this.groups;
    }

    public JaCaMoGroupParameters getGroup(String id) {
        for (JaCaMoGroupParameters g : this.groups) {
            JaCaMoGroupParameters gg = g.find(id);
            if (gg == null) continue;
            return gg;
        }
        return null;
    }

    public void addScheme(JaCaMoSchemeParameters s) {
        this.schemes.add(s);
    }

    public List<JaCaMoSchemeParameters> getSchemes() {
        return this.schemes;
    }

    public JaCaMoSchemeParameters getScheme(String id) {
        for (JaCaMoSchemeParameters s : this.schemes) {
            if (!s.getName().equals(id)) continue;
            return s;
        }
        return null;
    }

    public void setDebug(String arg) {
        this.debug = arg;
    }

    @Override
    public boolean hasDebug() {
        return this.debug != null;
    }

    public String getDebugConf() {
        return this.debug;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("   organisation " + this.name);
        s.append(" : " + this.getParameter("source"));
        s.append(" {\n");
        for (String k : this.parameters.keySet()) {
            if (k.equals("source")) continue;
            s.append("      " + k + ": " + this.parameters.get(k) + "\n");
        }
        String bgn = "      agents: ";
        for (AgentParameters ap : this.project.getAgents()) {
            JaCaMoAgentParameters jap = (JaCaMoAgentParameters)ap;
            for (String w : jap.getWorkspaces()) {
                if (!w.equals(this.name)) continue;
                s.append(bgn + ap.getAgName());
                bgn = ", ";
            }
        }
        s.append("\n");
        if (this.getNode() != null) {
            s.append("      node: " + this.getNode() + "\n");
        }
        for (JaCaMoGroupParameters g : this.groups) {
            s.append(g + "\n");
        }
        s.append("\n");
        for (JaCaMoSchemeParameters sch : this.schemes) {
            s.append(sch + "\n");
        }
        s.append("\n   }");
        return s.toString();
    }
}

