/*
 * Decompiled with CFR 0.152.
 */
package jacamo.project;

import jacamo.project.JaCaMoAgentParameters;
import jacamo.project.JaCaMoOrgParameters;
import jacamo.project.JaCaMoProject;
import jason.mas2j.AgentParameters;
import java.util.ArrayList;
import java.util.List;

public class JaCaMoGroupParameters
extends JaCaMoOrgParameters {
    protected String type;
    protected List<JaCaMoGroupParameters> subGroups = new ArrayList<JaCaMoGroupParameters>();
    protected List<String> responsibleFor = new ArrayList<String>();

    public JaCaMoGroupParameters(JaCaMoProject project) {
        super(project);
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void addSubGroup(JaCaMoGroupParameters sg) {
        this.subGroups.add(sg);
    }

    public List<JaCaMoGroupParameters> getSubGroups() {
        return this.subGroups;
    }

    public void addResponsibleFor(String s) {
        this.responsibleFor.add(s);
    }

    public List<String> getResponsibleFor() {
        return this.responsibleFor;
    }

    public JaCaMoGroupParameters find(String gId) {
        if (this.getName().equals(gId)) {
            return this;
        }
        for (JaCaMoGroupParameters sg : this.subGroups) {
            JaCaMoGroupParameters sgf = sg.find(gId);
            if (sgf == null) continue;
            return sgf;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("      group " + this.name + ": " + this.type);
        s.append(" {\n");
        for (String a : this.parameters.keySet()) {
            s.append("         " + a + ": " + (String)this.parameters.get(a) + "\n");
        }
        if (this.hasDebug()) {
            s.append("         debug: " + this.getDebugConf() + "\n");
        }
        if (!this.responsibleFor.isEmpty()) {
            s.append("         responsible-for: ");
            String v = "";
            for (String srf : this.responsibleFor) {
                s.append(v + srf);
                v = ",";
            }
        }
        String bgn = "         players: ";
        for (AgentParameters ap : this.project.getAgents()) {
            JaCaMoAgentParameters jap = (JaCaMoAgentParameters)ap;
            for (String[] r : jap.getRoles()) {
                if (!r[1].equals(this.name)) continue;
                s.append(bgn + ap.getAgName() + " " + r[2] + "\n");
                bgn = "                  ";
            }
        }
        for (JaCaMoGroupParameters sg : this.subGroups) {
            s.append("\n" + sg + "\n");
        }
        s.append("      }");
        return s.toString();
    }
}

