/*
 * Decompiled with CFR 0.152.
 */
package jacamo.project;

import jacamo.project.JaCaMoOrgParameters;
import jacamo.project.JaCaMoProject;
import jacamo.project.JaCaMoWorkspaceParameters;
import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import jason.asSyntax.parser.ParseException;
import jason.bb.DefaultBeliefBase;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class JaCaMoAgentParameters
extends AgentParameters {
    protected Set<String> wks = new TreeSet<String>();
    protected List<String[]> roles = new ArrayList<String[]>();
    protected List<String[]> focus = new ArrayList<String[]>();
    protected JaCaMoProject project;

    public JaCaMoAgentParameters(JaCaMoProject project) {
        this.project = project;
    }

    public JaCaMoAgentParameters(JaCaMoProject project, AgentParameters a) {
        super(a);
        this.project = project;
    }

    public void addInitBel(Literal l) {
        String op = this.getOption("beliefs");
        op = op == null ? "" : op + ",";
        op = op + l.toString();
        this.addOption("beliefs", op);
    }

    public void addInitGoal(Literal l) {
        String op = this.getOption("goals");
        op = op == null ? "" : op + ",";
        op = op + l.toString();
        this.addOption("goals", op);
    }

    @Override
    public AgentParameters copy() {
        JaCaMoAgentParameters newap = new JaCaMoAgentParameters(this.project);
        this.copyTo(newap);
        return newap;
    }

    protected void copyTo(JaCaMoAgentParameters newap) {
        super.copyTo(newap);
        newap.wks = new HashSet<String>(this.wks);
        newap.roles = new ArrayList<String[]>(this.roles);
        newap.focus = new ArrayList<String[]>(this.focus);
        newap.project = this.project;
    }

    public void addWorkspace(String w, String h) {
        this.wks.add(w);
        if (h != null) {
            this.project.setWorkspaceNode(w, h);
        }
    }

    public Collection<String> getWorkspaces() {
        ArrayList<String> wslocal = new ArrayList<String>();
        ArrayList<String> wsrem = new ArrayList<String>();
        for (String w : this.wks) {
            String n = this.project.getWorkspaceNode(w);
            if (n == null) {
                wslocal.add(w);
                continue;
            }
            if (this.project.getNodeHost(n) == null) {
                wslocal.add(w);
                continue;
            }
            wsrem.add(w);
        }
        wslocal.addAll(wsrem);
        return wslocal;
    }

    public void setProject(JaCaMoProject p) {
        this.project = p;
    }

    public JaCaMoProject getProject() {
        return this.project;
    }

    public void addRole(String org, String g, String r) {
        this.roles.add(new String[]{org, g, r});
    }

    public void addRole(String g, String r) {
        int pdot = g.indexOf(".");
        if (pdot > 0) {
            String orgId = g.substring(0, pdot);
            g = g.substring(pdot + 1);
            this.addRole(orgId, g, r);
        } else {
            this.addRole(null, g, r);
        }
    }

    public List<String[]> getRoles() {
        return this.roles;
    }

    public void addFocus(String artId, String namespace, String w, String n) {
        if (namespace == null) {
            namespace = Literal.DefaultNS.toString();
        }
        if (w != null && !this.wks.contains(w)) {
            this.addWorkspace(w, n);
        }
        this.focus.add(new String[]{artId, w, namespace});
    }

    public void addFocus(String artId, String namespace, String h) {
        int pdot = artId.indexOf(".");
        if (pdot > 0) {
            String workspaceId = artId.substring(0, pdot);
            artId = artId.substring(pdot + 1);
            this.addFocus(artId, namespace, workspaceId, h);
        } else {
            this.addFocus(artId, namespace, null, h);
        }
    }

    public void fix() {
        for (String[] f : this.focus) {
            JaCaMoWorkspaceParameters w;
            if (f[1] != null || (w = this.project.getArtifactWorkspace(f[0])) == null) continue;
            f[1] = w.getName();
            this.addWorkspace(w.getName(), w.getNode());
        }
        for (String[] r : this.roles) {
            JaCaMoOrgParameters o;
            if (r[0] != null || (o = this.project.getGroupOrg(r[1])) == null) continue;
            r[0] = o.getName();
            this.addWorkspace(o.getName(), o.getNode());
        }
    }

    public List<String[]> getFocus() {
        return this.focus;
    }

    @Override
    public String toString() {
        JaCaMoWorkspaceParameters jw;
        StringBuilder s = new StringBuilder("agent " + this.name);
        if (this.asSource != null && !this.asSource.getName().startsWith(this.name)) {
            s.append(" : " + this.asSource);
        }
        s.append(" {\n");
        if (this.getNbInstances() != 1) {
            s.append("      instances: " + this.getNbInstances() + "\n");
        }
        if (this.getHost() != null) {
            s.append("      node: " + this.getHost() + "\n");
        }
        if (this.agClass != null && this.agClass.getClassName().length() > 0 && !this.agClass.getClassName().equals(Agent.class.getName())) {
            s.append("      ag-class: " + this.agClass + "\n");
        }
        if (this.bbClass != null && this.bbClass.getClassName().length() > 0 && !this.bbClass.getClassName().equals(DefaultBeliefBase.class.getName())) {
            s.append("      ag-bb-class: " + this.bbClass + "\n");
        }
        boolean first = true;
        for (ClassParameters c : this.archClasses) {
            if (c.getClassName().length() <= 0 || c.getClassName().equals(AgArch.class.getName())) continue;
            if (first) {
                s.append("      ag-arch: " + c + "\n");
                first = false;
                continue;
            }
            s.append("               " + c + "\n");
        }
        if (this.options != null && !this.options.isEmpty()) {
            for (String k : this.options.keySet()) {
                try {
                    String bgn;
                    if (k.equals("beliefs")) {
                        s.append("      beliefs: ");
                        bgn = "";
                        for (Term t : ASSyntax.parseList("[" + (String)this.options.get(k) + "]")) {
                            s.append(bgn + t + "\n");
                            bgn = "               ";
                        }
                        continue;
                    }
                    if (k.equals("goals")) {
                        s.append("      goals:  ");
                        bgn = "";
                        for (Term t : ASSyntax.parseList("[" + (String)this.options.get(k) + "]")) {
                            s.append(bgn + t + "\n");
                            bgn = "              ";
                        }
                        continue;
                    }
                    s.append("      " + k + ": " + (String)this.options.get(k) + "         // app domain argument \n");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        String bgn = "\n      // join: ";
        for (String w : this.wks) {
            s.append(bgn + w);
            jw = this.project.getWorkspace(w);
            if (jw != null && jw.getNode() != null) {
                s.append("@" + jw.getNode());
            }
            bgn = ", ";
        }
        bgn = "\n      // focus: ";
        for (String[] f : this.focus) {
            s.append(bgn + f[1] + "." + f[0]);
            jw = this.project.getWorkspace(f[1]);
            if (jw != null && jw.getNode() != null) {
                s.append("@" + jw.getNode());
            }
            bgn = ", ";
        }
        bgn = "\n      // roles: ";
        for (String[] r : this.roles) {
            s.append(bgn + r[2] + " in " + r[0] + "." + r[1]);
            bgn = ", ";
        }
        return s.toString().trim() + "\n   }\n";
    }
}

