/*
 * Decompiled with CFR 0.152.
 */
package jacamo.infra;

import jacamo.project.JaCaMoProject;
import jacamo.project.parser.JaCaMoProjectParser;
import jacamo.util.Config;
import jason.infra.MASLauncherInfraTier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class RunJaCaMoProject {
    static MASLauncherInfraTier launcher;

    public static void main(String[] args) {
        boolean nrunmas;
        JaCaMoProjectParser parser;
        JaCaMoProject project = new JaCaMoProject();
        if (args.length == 0) {
            System.out.println(Config.get().getPresentation() + "\n");
            System.out.println("usage must be:");
            System.out.println("      java " + RunJaCaMoProject.class.getName() + " <JaCaMo Project File> [notrun]");
            return;
        }
        String name = args[0];
        System.err.println("reading from file " + name + " ...");
        try {
            parser = new JaCaMoProjectParser(new FileInputStream(name));
        }
        catch (FileNotFoundException e) {
            System.err.println("file \"" + name + "\" not found.");
            return;
        }
        boolean bl = nrunmas = args.length >= 2 && args[1].equals("notrun");
        if (!nrunmas) {
            nrunmas = args.length >= 3 && args[2].equals("notrun");
        }
        try {
            File file = new File(name);
            File directory = file.getAbsoluteFile().getParentFile();
            project = parser.parse(directory.toString());
            if (Config.get().getJaCaMoHome().isEmpty()) {
                if (Config.get().getUserConfFile().exists()) {
                    System.out.println("JaCaMo is not configured, creating a default configuration.");
                } else {
                    Config.get().setShowFixMsgs(false);
                }
                Config.get().fix();
            }
            project.setProjectFile(file);
            System.out.println("file " + name + " parsed successfully!\n");
            launcher = project.getInfrastructureFactory().createMASLauncher();
            launcher.setProject(project);
            launcher.writeScripts(false, false);
            if (nrunmas) {
                System.out.println("To run your MAS, just type \"ant -f bin/" + file.getName().substring(0, file.getName().length() - 3) + "xml\"");
            } else {
                new Thread((Runnable)launcher, "MAS-Launcher").start();
            }
        }
        catch (Exception e) {
            System.err.println("parsing errors found... \n" + e);
        }
    }

    public MASLauncherInfraTier getLauncher() {
        return launcher;
    }
}

