/*
 * Decompiled with CFR 0.152.
 */
package jacamo.infra;

import cartago.AgentCredential;
import cartago.AgentIdCredential;
import cartago.ArtifactId;
import cartago.CartagoContext;
import cartago.CartagoException;
import cartago.CartagoService;
import cartago.Op;
import cartago.OpFeedbackParam;
import cartago.WorkspaceId;
import jaca.CAgentArch;
import jaca.CartagoEnvironment;
import jacamo.infra.EnvironmentInspector;
import jacamo.infra.EnvironmentInspectorWeb;
import jacamo.infra.JaCaMoAgArch;
import jacamo.infra.JaCaMoRuntimeServices;
import jacamo.project.JaCaMoGroupParameters;
import jacamo.project.JaCaMoOrgParameters;
import jacamo.project.JaCaMoProject;
import jacamo.project.JaCaMoSchemeParameters;
import jacamo.project.JaCaMoWorkspaceParameters;
import jacamo.project.parser.JaCaMoProjectParser;
import jacamo.project.parser.ParseException;
import jacamo.util.Config;
import jason.JasonException;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.RunCentralisedMAS;
import jason.infra.jade.RunJadeMAS;
import jason.infra.repl.ReplAgGUI;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.runtime.MASConsoleGUI;
import jason.runtime.MASConsoleLogHandler;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import ora4mas.nopl.GroupBoard;
import ora4mas.nopl.OrgBoard;
import ora4mas.nopl.SchemeBoard;

public class JaCaMoLauncher
extends RunCentralisedMAS {
    protected CartagoEnvironment env;
    protected CartagoContext cartagoCtx;
    protected Map<String, ArtifactId> artIds = new HashMap<String, ArtifactId>();
    protected RunJadeMAS rJADE = null;
    public static String defaultProjectFileName = "default.jcm";

    public static void main(String[] args) throws JasonException {
        logger = Logger.getLogger(JaCaMoLauncher.class.getName());
        JaCaMoLauncher r = new JaCaMoLauncher();
        runner = r;
        r.init(args);
        r.create();
        r.start();
        r.waitEnd();
        r.finish();
    }

    public static JaCaMoLauncher getJaCaMoRunner() {
        return (JaCaMoLauncher)runner;
    }

    public JaCaMoProject getJaCaMoProject() {
        if (!(this.getProject() instanceof JaCaMoProject)) {
            project = new JaCaMoProject(this.getProject());
        }
        return (JaCaMoProject)this.getProject();
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new JaCaMoRuntimeServices(runner);
    }

    public ArtifactId getArtId(String artName) {
        return this.artIds.get(artName);
    }

    @Override
    public int init(String[] args) {
        String projectFileName = null;
        if (args.length < 1) {
            if (RunCentralisedMAS.class.getResource("/" + defaultProjectFileName) != null) {
                projectFileName = defaultProjectFileName;
                readFromJAR = true;
                Config.get(false);
            } else {
                System.out.println("JaCaMo " + Config.get().getJaCaMoVersion());
                System.err.println("You should inform the project file.");
                JOptionPane.showMessageDialog(null, "You should inform the project file as a parameter.\n\nJaCaMo version " + Config.get().getJaCaMoVersion(), "JaCaMo", 1);
                System.exit(0);
            }
        } else {
            Config.get();
            projectFileName = args[0];
        }
        if (Config.get().getJaCaMoHome().isEmpty()) {
            if (Config.get().getUserConfFile().exists()) {
                System.out.println("JaCaMo is not configured, creating a default configuration.");
            } else {
                Config.get().setShowFixMsgs(false);
            }
            Config.get().fix();
        }
        this.setupLogger();
        if (args.length >= 2 && args[1].equals("-debug")) {
            debug = true;
            Logger.getLogger("").setLevel(Level.FINE);
        }
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!h.getClass().toString().equals(MASConsoleLogHandler.class.toString())) continue;
            MASConsoleGUI.get().getFrame().setVisible(true);
            MASConsoleGUI.get().setAsDefaultOut();
        }
        int errorCode = 0;
        try {
            String[] argsWI;
            InputStream inProject;
            if (readFromJAR) {
                inProject = RunCentralisedMAS.class.getResource("/" + defaultProjectFileName).openStream();
                urlPrefix = "ClassResource:/";
            } else {
                URL file;
                try {
                    file = new URL(projectFileName);
                    if (projectFileName.startsWith("jar")) {
                        urlPrefix = projectFileName.substring(0, projectFileName.indexOf("!") + 1) + "/";
                    }
                }
                catch (Exception e) {
                    file = new URL("file:" + projectFileName);
                }
                inProject = file.openStream();
            }
            JaCaMoProjectParser parser = new JaCaMoProjectParser(inProject);
            String directory = null;
            try {
                directory = new File(projectFileName).getAbsoluteFile().getParentFile().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (directory == null) {
                directory = new File(".").getAbsoluteFile().getParentFile().toString();
            }
            try {
                project = parser.parse(directory);
            }
            catch (ParseException e) {
                if (e.toString().startsWith("jacamo.project.parser.ParseException: Encountered \"MAS\"")) {
                    return super.init(args);
                }
                logger.log(Level.SEVERE, "Error parsing file " + projectFileName + "!", e);
                errorCode = 3;
                return errorCode;
            }
            project.setupDefault();
            this.getJaCaMoProject().setUrlPrefix(urlPrefix);
            project.registerDirectives();
            ((Include)DirectiveProcessor.getDirective("include")).setSourcePath(project.getSourcePaths());
            if (MASConsoleGUI.hasConsole()) {
                MASConsoleGUI.get().setTitle("MAS Console - " + project.getSocName());
                if (!project.isJade()) {
                    super.createButtons();
                }
            }
            if ((argsWI = this.getJaCaMoProject().getPlatformParameters("startWebMindInspector")) != null) {
                Config.get().setProperty("startWebMindInspector", argsWI[0]);
            }
            if ((argsWI = this.getJaCaMoProject().getPlatformParameters("startWebEnvInspector")) != null) {
                Config.get().setProperty("startWebEnvInspector", argsWI[0]);
            }
            if ((argsWI = this.getJaCaMoProject().getPlatformParameters("startWebOrgInspector")) != null) {
                Config.get().setProperty("startWebOrgInspector", argsWI[0]);
            }
            errorCode = 0;
        }
        catch (FileNotFoundException e1) {
            logger.log(Level.SEVERE, "File " + projectFileName + " not found!");
            errorCode = 2;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error!?: ", e);
            errorCode = 4;
        }
        System.out.flush();
        System.err.flush();
        if (!MASConsoleGUI.hasConsole() && errorCode != 0) {
            System.exit(errorCode);
        }
        return errorCode;
    }

    @Override
    public void finish() {
        try {
            CartagoService.shutdownNode();
        }
        catch (CartagoException e) {
            e.printStackTrace();
        }
        super.finish();
    }

    @Override
    protected InputStream getDefaultLogProperties() throws IOException {
        return JaCaMoLauncher.class.getResource("/templates/logging.properties").openStream();
    }

    @Override
    public void create() throws JasonException {
        this.createEnvironment();
        this.createOrganisation();
        this.createAgs();
    }

    @Override
    public void createEnvironment() throws JasonException {
        this.env = new CartagoEnvironment();
        String[] args = this.getJaCaMoProject().getPlatformParameters("cartago");
        if (args == null) {
            args = new String[]{};
        }
        this.env.init(args);
        if (!"false".equals(Config.get().getProperty("startWebEnvInspector"))) {
            EnvironmentInspectorWeb.startHttpServer();
            EnvironmentInspectorWeb.registerWorkspace(CartagoService.MAIN_WSP_NAME);
        }
        try {
            this.cartagoCtx = CartagoService.startSession((String)CartagoService.MAIN_WSP_NAME, (AgentCredential)new AgentIdCredential("JaCaMo_Launcher"));
        }
        catch (CartagoException e1) {
            e1.printStackTrace();
            return;
        }
        for (JaCaMoWorkspaceParameters wp : this.getJaCaMoProject().getWorkspaces()) {
            try {
                if (!this.getJaCaMoProject().isInDeployment(wp.getNode())) continue;
                if (this.getJaCaMoProject().getNodeHost(wp.getNode()) != null) {
                    logger.warning("**** Remote workspace creation is not implemented yet! The workspace @ " + this.getJaCaMoProject().getNodeHost(wp.getNode()) + " wasn't created");
                    continue;
                }
                CartagoService.createWorkspace((String)wp.getName());
                logger.info("Workspace " + wp.getName() + " created.");
                EnvironmentInspectorWeb.registerWorkspace(wp.getName());
                this.cartagoCtx.joinWorkspace(wp.getName(), (AgentCredential)new AgentIdCredential("JaCaMoLauncherAg"));
                WorkspaceId wid = this.cartagoCtx.getJoinedWspId(wp.getName());
                for (String aName : wp.getArtifacts().keySet()) {
                    String m = null;
                    try {
                        ClassParameters cp = wp.getArtifacts().get(aName);
                        m = "artifact " + aName + ": " + cp.getClassName() + "(" + cp.getParametersStr(",") + ") at " + wp.getName();
                        ArtifactId aid = this.cartagoCtx.makeArtifact(wid, aName, cp.getClassName(), cp.getTypedParametersArray());
                        this.artIds.put(aName, aid);
                        logger.info(m + " created.");
                        if (!wp.hasDebug()) continue;
                        EnvironmentInspector.addInGui(wp.getName(), aid);
                    }
                    catch (CartagoException e) {
                        logger.log(Level.SEVERE, "error creating " + m, e);
                    }
                }
                if (!wp.hasDebug()) continue;
                CartagoService.enableDebug((String)wp.getName());
            }
            catch (CartagoException e) {
                logger.log(Level.SEVERE, "error creating environmet, workspace:" + wp.getName(), e);
            }
        }
    }

    protected void createOrganisation() {
        for (JaCaMoOrgParameters o : this.getJaCaMoProject().getOrgs()) {
            try {
                if (!this.getJaCaMoProject().isInDeployment(o.getNode())) continue;
                if (this.getJaCaMoProject().getNodeHost(o.getNode()) != null) {
                    logger.warning("**** Remote organisation creation is not implemented yet! The organisation @ " + this.getJaCaMoProject().getNodeHost(o.getNode()) + " wasn't created");
                    continue;
                }
                o.addParameter("source", this.getJaCaMoProject().getOrgPaths().fixPath(o.getParameter("source")));
                CartagoService.createWorkspace((String)o.getName());
                logger.info("Workspace " + o.getName() + " created.");
                this.cartagoCtx.joinWorkspace(o.getName(), (AgentCredential)new AgentIdCredential("JaCaMoLauncherAg"));
                WorkspaceId wid = this.cartagoCtx.getJoinedWspId(o.getName());
                ArtifactId aid = this.cartagoCtx.makeArtifact(wid, o.getName(), OrgBoard.class.getName(), new Object[]{o.getParameter("source")});
                for (JaCaMoSchemeParameters s : o.getSchemes()) {
                    this.createScheme(aid, s, o);
                }
                for (JaCaMoGroupParameters g : o.getGroups()) {
                    this.createGroup(aid, null, g, o);
                }
            }
            catch (CartagoException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createGroup(ArtifactId orgB, JaCaMoGroupParameters parent, JaCaMoGroupParameters g, JaCaMoOrgParameters org) {
        String m = g.getName() + ": " + g.getType() + " using artifact " + GroupBoard.class.getName();
        try {
            String owner;
            OpFeedbackParam fb = new OpFeedbackParam();
            this.cartagoCtx.doAction(orgB, new Op("createGroup", new Object[]{g.getName(), g.getType(), fb}));
            ArtifactId aid = (ArtifactId)fb.get();
            this.artIds.put(g.getName(), aid);
            logger.info("group created: " + m);
            if (g.hasDebug()) {
                this.cartagoCtx.doAction(aid, new Op("debug", new Object[]{g.getDebugConf()}));
            }
            if (parent != null) {
                this.cartagoCtx.doAction(aid, new Op("setParentGroup", new Object[]{parent.getName()}));
            }
            if ((owner = g.getParameter("owner")) != null) {
                this.cartagoCtx.doAction(aid, new Op("setOwner", new Object[]{owner}));
            }
            for (JaCaMoGroupParameters sg : g.getSubGroups()) {
                this.createGroup(orgB, g, sg, org);
            }
            for (String respFor : g.getResponsibleFor()) {
                if (org.getScheme(respFor) == null) {
                    logger.warning("** The scheme " + respFor + " does not existis in " + org.getName() + " so the group " + g.getName() + " cannot be responsible for it!");
                }
                this.cartagoCtx.doAction(aid, new Op("addSchemeWhenFormationOk", new Object[]{respFor}));
            }
        }
        catch (CartagoException e) {
            logger.log(Level.SEVERE, "error creating group " + m, e);
        }
    }

    protected void createScheme(ArtifactId orgB, JaCaMoSchemeParameters s, JaCaMoOrgParameters org) {
        String m = s.getName() + ": " + s.getType() + " using artifact " + SchemeBoard.class.getName();
        try {
            String owner;
            OpFeedbackParam fb = new OpFeedbackParam();
            this.cartagoCtx.doAction(orgB, new Op("createScheme", new Object[]{s.getName(), s.getType(), fb}));
            ArtifactId aid = (ArtifactId)fb.get();
            this.artIds.put(s.getName(), aid);
            logger.info("scheme created: " + m);
            if (s.hasDebug()) {
                this.cartagoCtx.doAction(aid, new Op("debug", new Object[]{s.getDebugConf()}));
            }
            if ((owner = s.getParameter("owner")) != null) {
                this.cartagoCtx.doAction(aid, new Op("setOwner", new Object[]{owner}));
            }
        }
        catch (CartagoException e) {
            logger.log(Level.SEVERE, "error creating scheme " + m, e);
        }
    }

    @Override
    public void createAgs() throws JasonException {
        if (this.getProject().isJade()) {
            this.rJADE = new RunJadeMAS();
            this.rJADE.setProject(project);
            this.rJADE.addInitArgs(this.getJaCaMoProject().getPlatformParameters("jade"));
            this.rJADE.createButtons();
            if (this.rJADE.startContainer()) {
                logger.info("Jade Container started.");
            } else {
                logger.log(Level.WARNING, "Error starting JADE container!");
                return;
            }
        }
        ArrayList<AgentParameters> lags = new ArrayList<AgentParameters>();
        for (AgentParameters ap : this.getJaCaMoProject().getAgents()) {
            if (ap.getNbInstances() <= 0 || !this.getJaCaMoProject().isInDeployment(ap.getHost())) continue;
            if (this.getJaCaMoProject().getNodeHost(ap.getHost()) != null) {
                logger.warning("**** Remote agent creation is not implemented yet! The agent " + ap.getAgName() + " @ " + this.getJaCaMoProject().getNodeHost(ap.getHost()) + " wasn't created");
                continue;
            }
            lags.add(ap);
            ap.insertArchClass(new ClassParameters(CAgentArch.class.getName()), new ClassParameters(JaCaMoAgArch.class.getName()));
            String debug = ap.getOption("debug");
            if (debug == null) continue;
            try {
                Literal lDebug = ASSyntax.parseLiteral(debug);
                ap.addOption(lDebug.getFunctor(), lDebug.getTerm(0).toString());
            }
            catch (jason.asSyntax.parser.ParseException e) {
                logger.log(Level.WARNING, "Error installing mind inspector for agent " + ap.getAgName(), e);
            }
        }
        project.getAgents().clear();
        project.getAgents().addAll(lags);
        project.fixAgentsSrc();
        if (this.getProject().isJade()) {
            if (this.getJaCaMoProject().hasPlatformParameter("jade", "-gui")) {
                Config.get().setProperty("jadeRMA", "false");
            }
            if (this.getJaCaMoProject().hasPlatformParameter("jade", "-sniffer")) {
                Config.get().setProperty("jadeSniffer", "false");
            }
            this.rJADE.createAgs();
        } else {
            super.createAgs();
        }
    }

    @Override
    protected void startAgs() {
        if (this.getProject().isJade()) {
            this.rJADE.startAgs();
        } else {
            super.startAgs();
        }
    }

    @Override
    protected void createReplAg(String n) {
        CentralisedAgArch agArch = new CentralisedAgArch();
        try {
            agArch.setAgName(n);
            ArrayList<String> archs = new ArrayList<String>();
            archs.add(CAgentArch.class.getName());
            archs.add(JaCaMoAgArch.class.getName());
            agArch.createArchs(archs, ReplAgGUI.class.getName(), null, null, new Settings(), this);
            Thread agThread = new Thread(agArch);
            agArch.setThread(agThread);
            agThread.start();
        }
        catch (JasonException e1) {
            e1.printStackTrace();
        }
        this.addAg(agArch);
    }
}

