/*
 * Decompiled with CFR 0.152.
 */
package jacamo.infra;

import cartago.CartagoException;
import cartago.Op;
import cartago.WorkspaceId;
import jaca.CAgentArch;
import jacamo.create_agent;
import jacamo.project.JaCaMoAgentParameters;
import jacamo.project.JaCaMoWorkspaceParameters;
import jason.architecture.AgArch;
import jason.asSemantics.Intention;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import java.util.logging.Level;

public class JaCaMoAgArch
extends AgArch {
    Atom jcmAtom = new Atom("jcm");

    @Override
    public void init() throws Exception {
        this.getTS().getAg().setIA("jason.stdlib.create_agent", new create_agent());
        JaCaMoAgentParameters ap = null;
        try {
            ap = (JaCaMoAgentParameters)this.getTS().getSettings().getUserParameters().get("project-parameter");
        }
        catch (Exception e) {
            this.getTS().getLogger().warning("error getting parameters to init JaCaMoAgArch! " + e);
            return;
        }
        if (ap == null) {
            return;
        }
        this.getTS().getLogger().fine("Using parameters from project " + ap.getProject().getSocName() + " for agent " + ap.getAgName());
        ListTermImpl lart = new ListTermImpl();
        ListTerm tail = lart;
        for (String wId : ap.getWorkspaces()) {
            try {
                Literal art;
                JaCaMoWorkspaceParameters w = ap.getProject().getWorkspace(wId);
                if (w == null) {
                    this.getTS().getLogger().warning("**** Workspace " + wId + " is not defined! The agent will not join it.");
                    continue;
                }
                String host = null;
                if (w.getNode() != null && !ap.getProject().isInDeployment(w.getNode())) {
                    host = ap.getProject().getNodeHost(w.getNode());
                    if (host == null) {
                        this.getTS().getLogger().warning("**** No host is defined for node " + w.getNode() + "! The agent will not join workspace " + w.getName());
                        continue;
                    }
                } else {
                    host = "local";
                }
                if (lart.contains(art = ASSyntax.createLiteral("art_env", ASSyntax.createAtom(w.getName()), ASSyntax.createString(host), ASSyntax.createString(""), Literal.DefaultNS))) continue;
                tail = tail.append(art);
            }
            catch (Exception e) {
                this.getTS().getLogger().log(Level.SEVERE, "error joining workspace " + wId, e);
            }
        }
        for (String[] f : ap.getFocus()) {
            Literal art;
            Object host = ap.getProject().getWorkspaceHost(f[1]);
            if (host == null) {
                host = "local";
            }
            if (lart.contains(art = ASSyntax.createLiteral("art_env", ASSyntax.createAtom(f[1]), ASSyntax.createString((String)host), ASSyntax.createAtom(f[0]), ASSyntax.parseTerm(f[2])))) continue;
            tail = tail.append(art);
        }
        ListTermImpl lroles = new ListTermImpl();
        tail = lroles;
        String host = null;
        for (String[] r : ap.getRoles()) {
            Literal role;
            if (r[0] == null) {
                this.getTS().getLogger().warning("No organisation for group " + r[1] + "! Ignoring role " + r[2]);
                continue;
            }
            host = ap.getProject().getWorkspaceHost(r[0]);
            if (host == null) {
                host = "local";
            }
            if (lroles.contains(role = ASSyntax.createLiteral("role", ASSyntax.createAtom(r[0]), ASSyntax.createString(host), ASSyntax.createAtom(r[1]), ASSyntax.createAtom(r[2])))) continue;
            tail = tail.append(role);
            Literal art = ASSyntax.createLiteral("art_env", ASSyntax.createAtom(r[0]), ASSyntax.createString(host), ASSyntax.createAtom(r[1]), Literal.DefaultNS);
            if (!lart.contains(art)) {
                lart.append(art);
            }
            if (lart.contains(art = ASSyntax.createLiteral("art_env", ASSyntax.createAtom(r[0]), ASSyntax.createString(host), ASSyntax.createAtom(r[0]), Literal.DefaultNS))) continue;
            lart.append(art);
        }
        if (!lart.isEmpty()) {
            if (this.getTS().getLogger().isLoggable(Level.FINE)) {
                this.getTS().getLogger().fine("producing goal to focus on " + lart);
            }
            Intention i = new Intention();
            i.setAtomic(1);
            this.getTS().getC().addAchvGoal(ASSyntax.createLiteral(this.jcmAtom, "focus_env_art", lart, ASSyntax.createNumber(3.0)), i);
        }
        if (!lroles.isEmpty()) {
            if (this.getTS().getLogger().isLoggable(Level.FINE)) {
                this.getTS().getLogger().fine("producing goal for initial roles " + lroles);
            }
            this.getTS().getC().addAchvGoal(ASSyntax.createLiteral(this.jcmAtom, "initial_roles", lroles, ASSyntax.createNumber(3.0)), Intention.EmptyInt);
        }
    }

    @Override
    public void stop() {
        super.stop();
        CAgentArch agent = this.getCartagoArch();
        for (WorkspaceId wid : agent.getAllJoinedWsps()) {
            try {
                agent.getSession().doAction(wid, new Op("quitWorkspace", new Object[0]), null, -1L);
            }
            catch (CartagoException cartagoException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected CAgentArch getCartagoArch() {
        for (AgArch arch = this.getTS().getUserAgArch().getFirstAgArch(); arch != null; arch = arch.getNextAgArch()) {
            if (!(arch instanceof CAgentArch)) continue;
            return (CAgentArch)arch;
        }
        return null;
    }
}

