/*
 * Decompiled with CFR 0.152.
 */
package jacamo.infra;

import cartago.ArtifactId;
import cartago.ArtifactInfo;
import cartago.ArtifactObsProperty;
import cartago.CartagoException;
import cartago.CartagoService;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;

public class EnvironmentInspector {
    private static JFrame frame;
    private static JTabbedPane allArtsPane;
    private static ScheduledThreadPoolExecutor updater;
    private static int guiCount;
    private static Map<String, JTextPane> artsPane;
    private static Map<String, String> artsWrps;
    private static Map<String, String> artsLast;

    private static void initFrame() {
        frame = new JFrame("..:: Environment Inspector ::..");
        allArtsPane = new JTabbedPane(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.add("Center", allArtsPane);
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds(0, 0, 800, (int)((double)screenSize.height * 0.8));
        frame.setLocation(screenSize.width / 2 - (guiCount += 30) - frame.getWidth() / 2, screenSize.height / 2 + guiCount - frame.getHeight() / 2);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public static void addInGui(String wksName, ArtifactId aId) {
        if (frame == null) {
            EnvironmentInspector.initFrame();
        }
        JTextPane txtOP = new JTextPane();
        JPanel nsp = new JPanel(new BorderLayout());
        txtOP.setContentType("text/html");
        txtOP.setEditable(false);
        txtOP.setAutoscrolls(false);
        nsp.add("Center", new JScrollPane(txtOP));
        String id = wksName + "." + aId.getName();
        artsWrps.put(id, wksName);
        artsPane.put(id, txtOP);
        allArtsPane.add(id, nsp);
        updater.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EnvironmentInspector.updateOP();
            }
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    static void updateOP() {
        for (String k : artsPane.keySet()) {
            try {
                String wks = artsWrps.get(k);
                String aname = k.substring(k.indexOf(".") + 1);
                ArtifactInfo info = CartagoService.getController((String)wks).getArtifactInfo(aname);
                String sOut = EnvironmentInspector.getArtHtml(wks, info, 5);
                String lastOut = artsLast.get(k);
                if (lastOut == null || !lastOut.endsWith(sOut)) {
                    artsPane.get(k).setText(sOut);
                }
                artsLast.put(k, sOut);
            }
            catch (CartagoException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getArtHtml(String wId, ArtifactInfo info, int refreshInterval) {
        StringBuilder out = new StringBuilder("<html>");
        out.append("<head><meta http-equiv=\"refresh\" content=\"" + refreshInterval + "\"></head>");
        out.append("<span style=\"color: red; font-family: arial\"><font size=\"+2\">");
        out.append("Inspection of artifact <b>" + info.getId().getName() + "</b> in workspace " + wId + "</font></span>");
        out.append("<table border=0 cellspacing=3 cellpadding=6 style='font-family:verdana'>");
        for (ArtifactObsProperty op : info.getObsProperties()) {
            out.append("<tr><td>" + op.getName() + "</td><td>" + op.getValue() + "</td></tr>");
        }
        out.append("</table>");
        out.append("</html>");
        return out.toString();
    }

    static {
        updater = new ScheduledThreadPoolExecutor(1);
        guiCount = 60;
        artsPane = new HashMap<String, JTextPane>();
        artsWrps = new HashMap<String, String>();
        artsLast = new HashMap<String, String>();
    }
}

