/*
 * Decompiled with CFR 0.152.
 */
package jason.util;

import jason.util.Config;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ConfigGUI {
    protected JTextField jasonTF;
    protected JTextField javaTF;
    protected JTextField antTF;
    protected JTextArea infraTP;
    protected JCheckBox closeAllCBox;
    protected JCheckBox checkVersionCBox;
    protected JCheckBox warnSingVarsCBox;
    protected JTextField jadeJarTF;
    protected JTextField jadeArgsTF;
    protected JCheckBox jadeSnifferCB;
    protected JCheckBox jadeRmaCB;
    protected JCheckBox shortUnnamedVarCB;
    protected static Config userProperties = Config.get();

    public static void main(String[] args) {
        new ConfigGUI().run();
    }

    protected static ConfigGUI getNewInstance() {
        return new ConfigGUI();
    }

    public void run() {
        final ConfigGUI jid = ConfigGUI.getNewInstance();
        JFrame f = null;
        try {
            f = new JFrame(jid.getWindowTitle());
        }
        catch (Exception e2) {
            userProperties.fix();
            userProperties.store();
            System.out.println("\nYou can edit the file " + userProperties.getUserConfFile() + " for your local configuration.");
            return;
        }
        f.setDefaultCloseOperation(3);
        JPanel pBt = new JPanel(new FlowLayout());
        JButton bQuit = new JButton("Exit without saving");
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
        pBt.add(bQuit);
        JButton bSave = new JButton("Save configuration and Exit");
        bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                jid.save();
                System.exit(0);
            }
        });
        pBt.add(bSave);
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", jid.getJasonConfigPanel());
        p.add("South", pBt);
        f.getContentPane().add(p);
        f.pack();
        f.setVisible(true);
    }

    protected String getWindowTitle() {
        return "Jason Configuration -- " + userProperties.getProperty("version");
    }

    public JPanel getJasonConfigPanel() {
        JPanel pop = new JPanel();
        pop.setLayout(new BoxLayout(pop, 1));
        this.jasonTF = new JTextField(25);
        JPanel jasonHomePanel = new JPanel(new GridLayout(0, 1));
        jasonHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Jason", 1, 2));
        JPanel jasonJarPanel = new JPanel(new FlowLayout(0));
        jasonJarPanel.add(new JLabel("jason.jar location"));
        jasonJarPanel.add(this.jasonTF);
        jasonJarPanel.add(this.createBrowseButton("jason.jar", this.jasonTF));
        jasonHomePanel.add(jasonJarPanel);
        JPanel checkVersionPanel = new JPanel(new FlowLayout(0));
        this.checkVersionCBox = new JCheckBox("Check for new Jason versions on startup", false);
        checkVersionPanel.add(this.checkVersionCBox);
        jasonHomePanel.add(checkVersionPanel);
        JPanel wsvPanel = new JPanel(new FlowLayout(0));
        this.warnSingVarsCBox = new JCheckBox("Print out warnings about singleton variables in plans and rules", false);
        wsvPanel.add(this.warnSingVarsCBox);
        jasonHomePanel.add(wsvPanel);
        JPanel unvPanel = new JPanel(new FlowLayout(0));
        this.shortUnnamedVarCB = new JCheckBox("Use short names for unamed variables (those starting with _)", false);
        unvPanel.add(this.shortUnnamedVarCB);
        jasonHomePanel.add(unvPanel);
        pop.add(jasonHomePanel);
        JPanel javaHomePanel = new JPanel();
        javaHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Java Home", 1, 2));
        javaHomePanel.setLayout(new FlowLayout(0));
        javaHomePanel.add(new JLabel("Directory"));
        this.javaTF = new JTextField(25);
        javaHomePanel.add(this.javaTF);
        JButton setJava = new JButton("Browse");
        setJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.setDialogTitle("Select the Java JDK home directory");
                    chooser.setFileSelectionMode(1);
                    if (chooser.showOpenDialog(null) == 0) {
                        String javaHome = new File(chooser.getSelectedFile().getPath()).getCanonicalPath();
                        if (Config.checkJavaHomePath(javaHome)) {
                            ConfigGUI.this.javaTF.setText(javaHome);
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected JDK home directory doesn't have the bin/javac file!");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        javaHomePanel.add(setJava);
        pop.add(javaHomePanel);
        JPanel antHomePanel = new JPanel();
        antHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Ant libs", 1, 2));
        antHomePanel.setLayout(new FlowLayout(0));
        antHomePanel.add(new JLabel("Directory"));
        this.antTF = new JTextField(25);
        antHomePanel.add(this.antTF);
        JButton setAnt = new JButton("Browse");
        setAnt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.setDialogTitle("Select the directory with ant.jar and ant-launcher.jar files");
                    chooser.setFileSelectionMode(1);
                    if (chooser.showOpenDialog(null) == 0) {
                        String antLib = new File(chooser.getSelectedFile().getPath()).getCanonicalPath();
                        if (Config.checkAntLib(antLib)) {
                            ConfigGUI.this.antTF.setText(antLib);
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected directory doesn't have the files ant.jar and ant-launcher.jar!");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        antHomePanel.add(setAnt);
        pop.add(antHomePanel);
        JPanel infraPanel = new JPanel();
        infraPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Available Insfrastructures", 1, 2));
        infraPanel.setLayout(new FlowLayout(0));
        this.infraTP = new JTextArea(5, 45);
        infraPanel.add(new JScrollPane(this.infraTP));
        pop.add(infraPanel);
        this.jadeJarTF = new JTextField(25);
        this.jadeArgsTF = new JTextField(30);
        JPanel jadeHomePanel = new JPanel(new GridLayout(0, 1));
        jadeHomePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JADE", 1, 2));
        JPanel jadeJarPanel = new JPanel(new FlowLayout(0));
        jadeJarPanel.add(new JLabel("jade.jar location"));
        jadeJarPanel.add(this.jadeJarTF);
        jadeJarPanel.add(this.createBrowseButton("jade.jar", this.jadeJarTF));
        jadeHomePanel.add(jadeJarPanel);
        JPanel jadeArgsPanel = new JPanel(new FlowLayout(0));
        jadeArgsPanel.add(new JLabel("jade.Boot arguments"));
        jadeArgsPanel.add(this.jadeArgsTF);
        jadeHomePanel.add(jadeArgsPanel);
        JPanel p = new JPanel(new FlowLayout(0));
        this.jadeRmaCB = new JCheckBox();
        this.jadeRmaCB.setToolTipText("Should the JADE management agent be run at startup?");
        p.add(this.jadeRmaCB);
        p.add(new JLabel("Start management agent             "));
        this.jadeSnifferCB = new JCheckBox();
        this.jadeSnifferCB.setToolTipText("Should the JADE sniffer agent be run at startup?");
        p.add(this.jadeSnifferCB);
        p.add(new JLabel("Start Sniffer"));
        jadeHomePanel.add(p);
        pop.add(jadeHomePanel);
        JPanel closeAllPanel = new JPanel();
        closeAllPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "jEdit options", 1, 2));
        closeAllPanel.setLayout(new FlowLayout(0));
        this.closeAllCBox = new JCheckBox("Close all files before opening a new Jason Project.");
        closeAllPanel.add(this.closeAllCBox);
        pop.add(closeAllPanel);
        this.jadeJarTF.setText(userProperties.getJadeJar());
        this.jadeArgsTF.setText(userProperties.getJadeArgs());
        this.jasonTF.setText(userProperties.getJasonJar());
        this.javaTF.setText(userProperties.getJavaHome());
        this.antTF.setText(userProperties.getAntLib());
        this.closeAllCBox.setSelected(userProperties.getBoolean("closeAllBeforeOpenMAS2J"));
        this.checkVersionCBox.setSelected(userProperties.getBoolean("checkLatestVersion"));
        this.warnSingVarsCBox.setSelected(userProperties.getBoolean("warnSingletonVars"));
        this.shortUnnamedVarCB.setSelected(userProperties.getBoolean("shortUnnamedVars"));
        this.jadeSnifferCB.setSelected(userProperties.getBoolean("jadeSniffer"));
        this.jadeRmaCB.setSelected(userProperties.getBoolean("jadeRMA"));
        for (String i : userProperties.getAvailableInfrastructures()) {
            this.infraTP.append(i + "=" + userProperties.getInfrastructureFactoryClass(i) + "\n");
        }
        return pop;
    }

    protected JButton createBrowseButton(final String jarfile, final JTextField tf) {
        JButton bt = new JButton("Browse");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.setDialogTitle("Select the " + jarfile + " file");
                    chooser.setFileFilter(new JarFileFilter("The " + jarfile + " file"));
                    if (chooser.showOpenDialog(null) == 0) {
                        String selJar = new File(chooser.getSelectedFile().getPath()).getCanonicalPath();
                        if (Config.checkJar(selJar)) {
                            tf.setText(selJar);
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected " + jarfile + " file was not ok!");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return bt;
    }

    public void save() {
        if (Config.checkJar(this.jadeJarTF.getText())) {
            userProperties.put("jadeJar", this.jadeJarTF.getText().trim());
        }
        userProperties.put("jadeArgs", this.jadeArgsTF.getText().trim());
        if (Config.checkJar(this.jasonTF.getText())) {
            userProperties.put("jasonJar", this.jasonTF.getText().trim());
        }
        if (Config.checkJavaHomePath(this.javaTF.getText()) || Config.checkJREHomePath(this.javaTF.getText())) {
            userProperties.setJavaHome(this.javaTF.getText().trim());
        }
        if (Config.checkAntLib(this.antTF.getText())) {
            userProperties.setAntLib(this.antTF.getText().trim());
        }
        userProperties.put("closeAllBeforeOpenMAS2J", this.closeAllCBox.isSelected() + "");
        userProperties.put("checkLatestVersion", this.checkVersionCBox.isSelected() + "");
        userProperties.put("warnSingletonVars", this.warnSingVarsCBox.isSelected() + "");
        userProperties.put("shortUnnamedVars", this.shortUnnamedVarCB.isSelected() + "");
        userProperties.put("jadeSniffer", this.jadeSnifferCB.isSelected() + "");
        userProperties.put("jadeRMA", this.jadeRmaCB.isSelected() + "");
        BufferedReader in = new BufferedReader(new StringReader(this.infraTP.getText()));
        try {
            String i;
            for (String s : userProperties.getAvailableInfrastructures()) {
                userProperties.removeInfrastructureFactoryClass(s);
            }
            while ((i = in.readLine()) != null) {
                int pos = i.indexOf("=");
                if (pos <= 0) continue;
                String infra = i.substring(0, pos);
                String factory = i.substring(pos + 1);
                userProperties.setInfrastructureFactoryClass(infra, factory);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        userProperties.store();
    }

    static {
        String currJasonVersion = userProperties.getJasonVersion();
        if (userProperties.getProperty("version") != null && !userProperties.getProperty("version").equals(currJasonVersion) && !currJasonVersion.equals("?")) {
            System.out.println("This is a new version of Jason, reseting configuration...");
            userProperties.remove("jadeJar");
            userProperties.remove("jasonJar");
            userProperties.remove("antLib");
            userProperties.remove("checkLatestVersion");
        }
        userProperties.fix();
        userProperties.store();
    }

    class JarFileFilter
    extends FileFilter {
        String ds;

        public JarFileFilter(String ds) {
            this.ds = ds;
        }

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith("jar") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.ds;
        }
    }
}

