/*
 * Decompiled with CFR 0.152.
 */
package jason.util;

import jason.asSemantics.TransitionSystem;
import jason.infra.centralised.CentralisedFactory;
import jason.infra.jade.JadeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class Config
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String JASON_JAR = "jasonJar";
    public static final String ANT_LIB = "antLib";
    public static final String JADE_JAR = "jadeJar";
    public static final String JADE_ARGS = "jadeArgs";
    public static final String JADE_RMA = "jadeRMA";
    public static final String JADE_SNIFFER = "jadeSniffer";
    public static final String JAVA_HOME = "javaHome";
    public static final String RUN_AS_THREAD = "runCentralisedInsideJIDE";
    public static final String SHELL_CMD = "shellCommand";
    public static final String CLOSEALL = "closeAllBeforeOpenMAS2J";
    public static final String CHECK_VERSION = "checkLatestVersion";
    public static final String WARN_SING_VAR = "warnSingletonVars";
    public static final String SHOW_ANNOTS = "showAnnots";
    public static final String SHORT_UNNAMED_VARS = "shortUnnamedVars";
    public static final String START_WEB_MI = "startWebMindInspector";
    public static final String START_WEB_EI = "startWebEnvInspector";
    public static final String START_WEB_OI = "startWebOrgInspector";
    public static final String NB_TH_SCH = "numberOfThreadsForScheduler";
    public static final String KQML_RECEIVED_FUNCTOR = "kqmlReceivedFunctor";
    public static final String KQML_PLANS_FILE = "kqmlPlansFile";
    protected static Config singleton = null;
    protected static String configFactory = null;
    protected static boolean showFixMsgs = true;

    public static void setClassFactory(String f) {
        singleton = null;
        configFactory = f;
    }

    public static Config get() {
        return Config.get(false);
    }

    public static Config get(boolean tryToFixConfig) {
        if (singleton == null) {
            if (configFactory == null) {
                configFactory = Config.class.getName();
            }
            try {
                singleton = (Config)Class.forName(configFactory).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Error creating config from " + configFactory + "(" + e2 + "), using default.");
                singleton = new Config();
            }
            if (!singleton.load() && tryToFixConfig) {
                singleton.fix();
                singleton.store();
            }
        }
        return singleton;
    }

    protected Config() {
    }

    public void setShowFixMsgs(boolean b) {
        showFixMsgs = b;
    }

    public File getUserConfFile() {
        return new File(System.getProperties().get("user.home") + File.separator + ".jason/user.properties");
    }

    public File getMasterConfFile() {
        return new File("jason.properties");
    }

    public String getFileConfComment() {
        return "Jason user configuration";
    }

    public boolean load() {
        try {
            File f = this.getUserConfFile();
            if (f.exists()) {
                super.load(new FileInputStream(f));
                return true;
            }
            f = this.getMasterConfFile();
            if (f.exists()) {
                System.out.println("User config file not found, loading master: " + f.getAbsolutePath());
                super.load(new FileInputStream(f));
                return true;
            }
        }
        catch (Exception e2) {
            System.err.println("Error reading preferences");
            e2.printStackTrace();
        }
        return false;
    }

    public boolean getBoolean(String key) {
        return "true".equals(this.get(key));
    }

    public String getJasonJar() {
        return this.getProperty(JASON_JAR);
    }

    public String getJasonHome() {
        try {
            return new File(this.getJasonJar()).getParentFile().getParent();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getJadeJar() {
        return this.getProperty(JADE_JAR);
    }

    public String getJadeArgs() {
        String a = this.getProperty(JADE_ARGS);
        return a == null ? "" : a;
    }

    public String[] getJadeArrayArgs() {
        ArrayList<String> ls = new ArrayList<String>();
        String jadeargs = this.getProperty(JADE_ARGS);
        if (jadeargs != null && jadeargs.length() > 0) {
            StringTokenizer t = new StringTokenizer(jadeargs);
            while (t.hasMoreTokens()) {
                ls.add(t.nextToken());
            }
        }
        String[] as = new String[ls.size()];
        for (int i = 0; i < ls.size(); ++i) {
            as[i] = (String)ls.get(i);
        }
        return as;
    }

    public String getJavaHome() {
        String h = this.getProperty(JAVA_HOME);
        if (!h.endsWith(File.separator)) {
            h = h + File.separator;
        }
        return h;
    }

    public String getAntLib() {
        return this.getProperty(ANT_LIB);
    }

    public String getAntJar() {
        File fAnt;
        String ant = this.getAntLib();
        if (ant != null && (ant = Config.findJarInDirectory(new File(ant), "ant-launcher")) != null && (fAnt = new File(ant)).exists()) {
            return fAnt.getName();
        }
        return null;
    }

    public void setJavaHome(String jh) {
        if (jh != null) {
            if (!(jh = new File(jh).getAbsolutePath()).endsWith(File.separator)) {
                jh = jh + File.separator;
            }
            this.put(JAVA_HOME, jh);
        }
    }

    public void setAntLib(String al) {
        if (al != null) {
            if (!(al = new File(al).getAbsolutePath()).endsWith(File.separator)) {
                al = al + File.separator;
            }
            this.put(ANT_LIB, al);
        }
    }

    public String getShellCommand() {
        return this.getProperty(SHELL_CMD);
    }

    public String getKqmlFunctor() {
        return this.getProperty(KQML_RECEIVED_FUNCTOR, "kqml_received");
    }

    public String getKqmlPlansFile() {
        return this.getProperty(KQML_PLANS_FILE, "$jasonJar/asl/kqmlPlans.asl");
    }

    public void resetSomeProps() {
        this.remove(JASON_JAR);
        this.remove(JADE_JAR);
        this.remove(ANT_LIB);
        this.put(SHOW_ANNOTS, "false");
    }

    public void fix() {
        this.tryToFixJarFileConf(JASON_JAR, "jason", 700000);
        this.tryToFixJarFileConf(JADE_JAR, "jade", 2000000);
        this.tryToFixJarFileConf(JASON_JAR, "jason", 700000);
        if (this.get(JAVA_HOME) == null || !Config.checkJavaHomePath(this.getProperty(JAVA_HOME))) {
            String javaHome = System.getProperty("java.home");
            if (Config.checkJavaHomePath(javaHome)) {
                this.setJavaHome(javaHome);
            } else {
                String javaEnvHome = System.getenv("JAVA_HOME");
                if (javaEnvHome != null && Config.checkJavaHomePath(javaEnvHome)) {
                    this.setJavaHome(javaEnvHome);
                } else {
                    String javaHomeUp = javaHome + File.separator + "..";
                    if (Config.checkJavaHomePath(javaHomeUp)) {
                        this.setJavaHome(javaHomeUp);
                    } else if (Config.checkJREHomePath(javaHome)) {
                        this.setJavaHome(javaHome);
                    } else {
                        this.setJavaHome(File.separator);
                    }
                }
            }
        }
        if (this.get(ANT_LIB) == null || !Config.checkAntLib(this.getAntLib())) {
            try {
                String jjar = this.getJasonJar();
                if (jjar != null) {
                    String antlib = new File(jjar).getParentFile().getParentFile().getAbsolutePath() + File.separator + "libs";
                    if (Config.checkAntLib(antlib)) {
                        this.setAntLib(antlib);
                    } else {
                        antlib = new File(".") + File.separator + "libs";
                        if (Config.checkAntLib(antlib)) {
                            this.setAntLib(antlib);
                        } else {
                            antlib = new File("..") + File.separator + "libs";
                            if (Config.checkAntLib(antlib)) {
                                this.setAntLib(antlib);
                            }
                        }
                    }
                }
            }
            catch (Exception e2) {
                System.out.println("Error setting ant lib!");
                e2.printStackTrace();
            }
        }
        if (this.get("font") == null) {
            this.put("font", "Monospaced");
        }
        if (this.get("fontSize") == null) {
            this.put("fontSize", "14");
        }
        if (this.get(SHELL_CMD) == null) {
            if (System.getProperty("os.name").startsWith("Windows 9")) {
                this.put(SHELL_CMD, "command.com /e:1024 /c ");
            } else if (System.getProperty("os.name").indexOf("indows") > 0) {
                this.put(SHELL_CMD, "cmd /c ");
            } else {
                this.put(SHELL_CMD, "/bin/sh ");
            }
        }
        if (this.get(CLOSEALL) == null) {
            this.put(CLOSEALL, "true");
        }
        if (this.get(CHECK_VERSION) == null) {
            this.put(CHECK_VERSION, "true");
        }
        if (this.getProperty(JADE_RMA) == null) {
            this.put(JADE_RMA, "true");
        }
        if (this.getProperty(SHOW_ANNOTS) == null) {
            this.put(SHOW_ANNOTS, "true");
        }
        if (this.getProperty(START_WEB_MI) == null) {
            this.put(START_WEB_MI, "true");
        }
        if (this.getProperty(NB_TH_SCH) == null) {
            this.put(NB_TH_SCH, "2");
        }
        if (this.getProperty(SHORT_UNNAMED_VARS) == null) {
            this.put(SHORT_UNNAMED_VARS, "true");
        }
        if (this.getProperty(KQML_RECEIVED_FUNCTOR) == null) {
            this.put(KQML_RECEIVED_FUNCTOR, "kqml_received");
        }
        if (this.getProperty(KQML_PLANS_FILE) == null) {
            this.put(KQML_PLANS_FILE, "$jasonJar/asl/kqmlPlans.asl");
        }
        this.setDefaultInfra();
    }

    private void setDefaultInfra() {
        this.put("infrastructure.Centralised", CentralisedFactory.class.getName());
        this.put("infrastructure.Jade", JadeFactory.class.getName());
    }

    public void store() {
        this.store(this.getUserConfFile());
    }

    public void store(File f) {
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            System.out.println("Storing configuration at " + f.getAbsolutePath());
            super.store(new FileOutputStream(f), this.getFileConfComment());
        }
        catch (Exception e2) {
            System.err.println("Error writting preferences");
            e2.printStackTrace();
        }
    }

    public String[] getAvailableInfrastructures() {
        try {
            ArrayList<String> infras = new ArrayList<String>();
            infras.add("Centralised");
            for (Object k : this.keySet()) {
                String newinfra;
                String sk = k.toString();
                int p = sk.indexOf(".");
                if (p <= 0 || !sk.startsWith("infrastructure") || p != sk.lastIndexOf(".") || infras.contains(newinfra = sk.substring(p + 1))) continue;
                infras.add(newinfra);
            }
            if (infras.size() > 0) {
                String[] r = new String[infras.size()];
                for (int i = 0; i < r.length; ++i) {
                    r[i] = (String)infras.get(i);
                }
                return r;
            }
        }
        catch (Exception e2) {
            System.err.println("Error getting user infrastructures.");
        }
        return new String[]{"Centralised", "Jade"};
    }

    public String getInfrastructureFactoryClass(String infraId) {
        Object oClass = this.get("infrastructure." + infraId);
        if (oClass == null) {
            this.setDefaultInfra();
            oClass = this.get("infrastructure." + infraId);
        }
        return oClass.toString();
    }

    public void setInfrastructureFactoryClass(String infraId, String factory) {
        this.put("infrastructure." + infraId, factory);
    }

    public void removeInfrastructureFactoryClass(String infraId) {
        this.remove("infrastructure." + infraId);
    }

    public String getJasonVersion() {
        Package j = Package.getPackage("jason.util");
        if (j != null) {
            return j.getSpecificationVersion();
        }
        return "?";
    }

    public String getJasonBuiltDate() {
        Package j = Package.getPackage("jason.util");
        if (j != null) {
            return j.getImplementationVersion();
        }
        return "?";
    }

    public void tryToFixJarFileConf(String jarEntry, String jarFilePrefix, int minSize) {
        String jarFile = this.getProperty(jarEntry);
        if (jarFile == null || !Config.checkJar(jarFile, minSize)) {
            String jwsDir;
            if (showFixMsgs) {
                System.out.println("Wrong configuration for " + jarFilePrefix + ", current is " + jarFile);
            }
            if (Config.checkJar(jarFile = this.getJarFromEclipseInstallation(jarFilePrefix), minSize)) {
                this.put(jarEntry, jarFile);
                if (showFixMsgs) {
                    System.out.println("found at " + jarFile + " in eclipse installation");
                }
                return;
            }
            jarFile = Config.findJarInDirectory(new File("."), jarFilePrefix);
            if (Config.checkJar(jarFile, minSize)) {
                try {
                    this.put(jarEntry, new File(jarFile).getCanonicalFile().getAbsolutePath());
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile);
                    }
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            if (Config.checkJar(jarFile = Config.getJarFromClassPath(jarFilePrefix), minSize)) {
                this.put(jarEntry, jarFile);
                if (showFixMsgs) {
                    System.out.println("found at " + jarFile + " by classpath");
                }
                return;
            }
            try {
                File jasonjardir = new File(this.getJasonJar()).getAbsoluteFile().getCanonicalFile().getParentFile();
                jarFile = Config.findJarInDirectory(jasonjardir, jarFilePrefix);
                if (Config.checkJar(jarFile, minSize)) {
                    this.put(jarEntry, jarFile);
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile + " by jason.jar directory");
                    }
                    return;
                }
            }
            catch (Exception jasonjardir) {
                // empty catch block
            }
            jarFile = Config.findJarInDirectory(new File(".." + File.separator + "libs"), jarFilePrefix);
            if (Config.checkJar(jarFile, minSize)) {
                try {
                    this.put(jarEntry, new File(jarFile).getCanonicalFile().getAbsolutePath());
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile);
                    }
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (Config.checkJar(jarFile = Config.findJarInDirectory(new File("libs"), jarFilePrefix), minSize)) {
                try {
                    this.put(jarEntry, new File(jarFile).getCanonicalFile().getAbsolutePath());
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile);
                    }
                    return;
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
            if (Config.checkJar(jarFile = Config.findJarInDirectory(new File("bin"), jarFilePrefix), minSize)) {
                try {
                    this.put(jarEntry, new File(jarFile).getCanonicalFile().getAbsolutePath());
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile);
                    }
                    return;
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            }
            if ((jwsDir = System.getProperty("jnlpx.deployment.user.home")) == null) {
                try {
                    jwsDir = System.getProperty("deployment.user.security.trusted.certs");
                    jwsDir = new File(jwsDir).getParentFile().getParent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jwsDir != null) {
                jarFile = Config.findFile(new File(jwsDir), jarFilePrefix, minSize);
                if (showFixMsgs) {
                    System.out.print("Searching " + jarFilePrefix + " in " + jwsDir + " ... ");
                }
                if (jarFile != null && Config.checkJar(jarFile)) {
                    if (showFixMsgs) {
                        System.out.println("found at " + jarFile);
                    }
                    this.put(jarEntry, jarFile);
                    return;
                }
                this.put(jarEntry, File.separator);
            }
            if (showFixMsgs) {
                System.out.println(jarFilePrefix + " not found");
            }
        }
    }

    static String findFile(File p, String file, int minSize) {
        if (p.isDirectory()) {
            File[] files = p.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    String r = Config.findFile(files[i], file, minSize);
                    if (r == null) continue;
                    return r;
                }
                if (!files[i].getName().endsWith(file) || files[i].length() <= (long)minSize) continue;
                return files[i].getAbsolutePath();
            }
        }
        return null;
    }

    public static String findJarInDirectory(File dir, String prefix2) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (!f.getName().startsWith(prefix2) || !f.getName().endsWith(".jar") || f.getName().endsWith("-sources.jar") || f.getName().endsWith("-javadoc.jar")) continue;
                return f.getAbsolutePath();
            }
        }
        return null;
    }

    public static boolean checkJar(String jar) {
        try {
            return jar != null && new File(jar).exists() && jar.endsWith(".jar");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkJar(String jar, int minSize) {
        try {
            return Config.checkJar(jar) && new File(jar).length() > (long)minSize;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkJavaHomePath(String javaHome) {
        try {
            if (!javaHome.endsWith(File.separator)) {
                javaHome = javaHome + File.separator;
            }
            File javac1 = new File(javaHome + "bin" + File.separatorChar + "javac");
            File javac2 = new File(javaHome + "bin" + File.separatorChar + "javac.exe");
            if (javac1.exists() || javac2.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkJREHomePath(String javaHome) {
        try {
            if (!javaHome.endsWith(File.separator)) {
                javaHome = javaHome + File.separator;
            }
            File javac1 = new File(javaHome + "bin" + File.separatorChar + "java");
            File javac2 = new File(javaHome + "bin" + File.separatorChar + "java.exe");
            if (javac1.exists() || javac2.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkAntLib(String al) {
        try {
            if (!al.endsWith(File.separator)) {
                al = al + File.separator;
            }
            if (Config.findJarInDirectory(new File(al), "ant") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static String getJarFromClassPath(String file) {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File f = new File(token);
            if (!f.getName().startsWith(file) || !f.getName().endsWith(".jar") || f.getName().endsWith("-sources.jar") || f.getName().endsWith("-javadoc.jar")) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    protected String getEclipseInstallationDirectory() {
        return "jason";
    }

    private String getJarFromEclipseInstallation(String file) {
        String eclipse = System.getProperty("eclipse.launcher");
        if (eclipse != null) {
            File f = new File(eclipse).getParentFile().getParentFile();
            if (eclipse.contains("Eclipse.app/Contents")) {
                f = f.getParentFile().getParentFile();
            }
            return Config.findJarInDirectory(new File(f + "/" + this.getEclipseInstallationDirectory() + "/libs"), file);
        }
        return null;
    }

    public String getTemplate(String templateName) {
        try {
            if (templateName.equals("agent.asl")) {
                templateName = "agent";
            }
            if (templateName.equals("project.mas2j")) {
                templateName = "project";
            }
            String nl = System.getProperty("line.separator");
            File bt = new File("src/templates/" + templateName);
            BufferedReader in = bt.exists() ? new BufferedReader(new FileReader(bt)) : ((bt = new File("../src/templates/" + templateName)).exists() ? new BufferedReader(new FileReader(bt)) : ((bt = new File(this.getHome() + "/src/templates/" + templateName)).exists() ? new BufferedReader(new FileReader(bt)) : ((bt = new File(this.getHome() + "/src/main/resources/templates/" + templateName)).exists() ? new BufferedReader(new FileReader(bt)) : new BufferedReader(new InputStreamReader(this.getDetaultResource(templateName))))));
            StringBuilder scriptBuf = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                scriptBuf.append(line + nl);
                line = in.readLine();
            }
            return scriptBuf.toString();
        }
        catch (Exception e2) {
            System.err.println("Error reading template: " + templateName);
            e2.printStackTrace();
            return null;
        }
    }

    protected String getHome() {
        return this.getJasonHome();
    }

    public InputStream getDetaultResource(String templateName) throws IOException {
        return TransitionSystem.class.getResource("/templates/" + templateName).openStream();
    }

    public static void main(String[] args) {
        Config.get().fix();
        Config.get().store();
    }

    public String getMindInspectorArchClassName() {
        return "jason.architecture.MindInspectorAgArch";
    }

    public String getMindInspectorWebServerClassName() {
        return "jason.architecture.MindInspectorWebImpl";
    }

    public String getPresentation() {
        return "Jason " + this.getJasonVersion() + "\n     built on " + this.getJasonBuiltDate() + "\n     installed at " + this.getHome();
    }
}

