/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.CircumstanceListener;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class wait
extends DefaultInternalAction {
    public static final String waitAtom = ".wait";

    @Override
    public boolean canBeUsedInContext() {
        return false;
    }

    @Override
    public boolean suspendIntention() {
        return true;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        long timeout = -1L;
        Trigger te = null;
        LogicalFormula f = null;
        Term elapsedTime = null;
        if (args[0].isNumeric()) {
            NumberTerm time2 = (NumberTerm)args[0];
            timeout = (long)time2.solve();
        } else {
            te = Trigger.tryToGetTrigger(args[0]);
            if (te == null && args[0] instanceof LogicalFormula) {
                f = (LogicalFormula)args[0];
                if (ts.getAg().believes(f, un)) {
                    Intention si = ts.getC().getSelectedIntention();
                    si.peek().removeCurrentStep();
                    ts.getC().addIntention(si);
                    return true;
                }
            }
            if (args.length >= 2) {
                timeout = (long)((NumberTerm)args[1]).solve();
            }
            if (args.length == 3) {
                elapsedTime = args[2];
            }
        }
        new WaitEvent(te, f, un, ts, timeout, elapsedTime);
        return true;
    }

    class WaitEvent
    implements CircumstanceListener {
        private Trigger te;
        private LogicalFormula formula;
        private String sEvt;
        private Unifier un;
        private Intention si;
        private TransitionSystem ts;
        private Circumstance c;
        private boolean dropped = false;
        private Term elapsedTimeTerm;
        private long startTime;

        WaitEvent(Trigger te, LogicalFormula f, Unifier un, TransitionSystem ts, long timeout, Term elapsedTimeTerm) {
            this.te = te;
            this.formula = f;
            this.un = un;
            this.ts = ts;
            this.c = ts.getC();
            this.si = this.c.getSelectedIntention();
            this.elapsedTimeTerm = elapsedTimeTerm;
            this.c.addEventListener(this);
            this.sEvt = te != null ? te.toString() : (this.formula != null ? this.formula.toString() : "time" + timeout);
            this.sEvt = this.si.getId() + "/" + this.sEvt;
            this.c.addPendingIntention(this.sEvt, this.si);
            this.startTime = System.currentTimeMillis();
            if (timeout >= 0L) {
                Agent.getScheduler().schedule(new Runnable(){

                    @Override
                    public void run() {
                        WaitEvent.this.resume(true);
                    }
                }, timeout, TimeUnit.MILLISECONDS);
            }
        }

        void resume(final boolean stopByTimeout) {
            this.c.removeEventListener(this);
            this.ts.runAtBeginOfNextCycle(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!(WaitEvent.this.c.removePendingIntention(WaitEvent.this.sEvt) != WaitEvent.this.si || !WaitEvent.this.si.isAtomic() && WaitEvent.this.c.hasIntention(WaitEvent.this.si) || WaitEvent.this.dropped)) {
                            if (stopByTimeout && WaitEvent.this.te != null && WaitEvent.this.elapsedTimeTerm == null) {
                                if (WaitEvent.this.si.isSuspended()) {
                                    PlanBody body = WaitEvent.this.si.peek().getPlan().getBody();
                                    body.add(1, new PlanBodyImpl(PlanBody.BodyType.internalAction, (Term)new InternalActionLiteral(".fail")));
                                    WaitEvent.this.c.addPendingIntention("suspended-" + WaitEvent.this.si.getId(), WaitEvent.this.si);
                                } else {
                                    WaitEvent.this.ts.generateGoalDeletion(WaitEvent.this.si, JasonException.createBasicErrorAnnots("wait_timeout", "timeout in .wait"));
                                }
                            } else if (!WaitEvent.this.si.isFinished()) {
                                WaitEvent.this.si.peek().removeCurrentStep();
                                if (WaitEvent.this.elapsedTimeTerm != null) {
                                    long elapsedTime = System.currentTimeMillis() - WaitEvent.this.startTime;
                                    WaitEvent.this.un.unifies(WaitEvent.this.elapsedTimeTerm, new NumberTermImpl(elapsedTime));
                                }
                                if (WaitEvent.this.si.isSuspended()) {
                                    WaitEvent.this.c.addPendingIntention("suspended-" + WaitEvent.this.si.getId(), WaitEvent.this.si);
                                } else {
                                    WaitEvent.this.c.resumeIntention(WaitEvent.this.si);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        WaitEvent.this.ts.getLogger().log(Level.SEVERE, "Error at .wait thread", e2);
                    }
                }
            });
            this.ts.getUserAgArch().wakeUpDeliberate();
        }

        @Override
        public void eventAdded(Event e2) {
            if (this.dropped) {
                return;
            }
            if (this.te != null && this.un.unifies(this.te, e2.getTrigger())) {
                this.resume(false);
            } else if (this.formula != null && this.ts.getAg().believes(this.formula, this.un)) {
                this.resume(false);
            }
        }

        @Override
        public void intentionDropped(Intention i) {
            if (i.equals(this.si)) {
                this.dropped = true;
                this.resume(false);
            }
        }

        @Override
        public void intentionAdded(Intention i) {
        }

        @Override
        public void intentionResumed(Intention i) {
        }

        @Override
        public void intentionSuspended(Intention i, String reason) {
        }

        public String toString() {
            return this.sEvt;
        }
    }
}

