/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class puts
extends DefaultInternalAction {
    private static final long serialVersionUID = 1L;
    private static InternalAction singleton = null;
    Pattern regex = Pattern.compile("#\\{[\\p{Alnum}_]+\\}");

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new puts();
        }
        return singleton;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!args[0].isString()) {
            throw JasonException.createWrongArgument(this, "first argument must be a string");
        }
    }

    @Override
    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        StringBuffer sb = new StringBuffer();
        for (Term term : args) {
            if (!term.isString()) continue;
            StringTerm st = (StringTerm)term;
            Matcher matcher = this.regex.matcher(st.getString());
            while (matcher.find()) {
                String sVar = matcher.group();
                sVar = sVar.substring(2, sVar.length() - 1);
                try {
                    Term t = null;
                    t = sVar.startsWith("_") && sVar.length() > 1 ? new UnnamedVar(Integer.valueOf(sVar.substring(1))) : ASSyntax.parseTerm(sVar);
                    t = t.capply(un);
                    matcher.appendReplacement(sb, t.isString() ? ((StringTerm)t).getString() : t.toString());
                }
                catch (ParseException pe) {
                    matcher.appendReplacement(sb, "#{" + sVar + "}");
                }
            }
            matcher.appendTail(sb);
        }
        if (args[args.length - 1].isVar()) {
            StringTermImpl stRes = new StringTermImpl(sb.toString());
            return un.unifies(stRes, args[args.length - 1]);
        }
        ts.getLogger().info(sb.toString());
        return true;
    }

    public void makeVarsAnnon(Literal l, Unifier un) {
        try {
            for (int i = 0; i < l.getArity(); ++i) {
                Term t = l.getTerm(i);
                if (!t.isString()) continue;
                StringTerm st = (StringTerm)t;
                Matcher matcher = this.regex.matcher(st.getString());
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String sVar = matcher.group();
                    Term v = ASSyntax.parseTerm(sVar = sVar.substring(2, sVar.length() - 1));
                    if (!v.isVar()) continue;
                    VarTerm to = ((Structure)l).varToReplace(v, un);
                    matcher.appendReplacement(sb, "#{" + to.toString() + "}");
                }
                matcher.appendTail(sb);
                l.setTerm(i, new StringTermImpl(sb.toString()));
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }
}

