/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.ListTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import java.util.Iterator;

public class nth
extends DefaultInternalAction {
    private static InternalAction singleton = null;

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new nth();
        }
        return singleton;
    }

    @Override
    public int getMinArgs() {
        return 3;
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!args[0].isNumeric() && !args[0].isVar()) {
            throw JasonException.createWrongArgument(this, "the first argument should be numeric or a variable -- not '" + args[0] + "'.");
        }
        if (!args[1].isList()) {
            throw JasonException.createWrongArgument(this, "the second argument should be a list and not '" + args[1] + "'.");
        }
    }

    @Override
    public Object execute(TransitionSystem ts, final Unifier un, final Term[] args) throws Exception {
        this.checkArguments(args);
        ListTerm list2 = (ListTerm)args[1];
        if (args[0].isNumeric()) {
            int index = (int)((NumberTerm)args[0]).solve();
            if (index < 0 || index >= list2.size()) {
                throw new JasonException("nth: index " + index + " is out of bounds (" + list2.size() + ")");
            }
            return un.unifies(args[2], (Term)list2.get(index));
        }
        if (args[0].isVar()) {
            final Iterator ilist = list2.iterator();
            return new Iterator<Unifier>(){
                int index = -1;
                Unifier c = null;

                @Override
                public boolean hasNext() {
                    if (this.c == null) {
                        this.find();
                    }
                    return this.c != null;
                }

                @Override
                public Unifier next() {
                    if (this.c == null) {
                        this.find();
                    }
                    Unifier b = this.c;
                    this.find();
                    return b;
                }

                void find() {
                    while (ilist.hasNext()) {
                        ++this.index;
                        Term candidate = (Term)ilist.next();
                        this.c = un.clone();
                        if (!this.c.unifiesNoUndo(args[2], candidate)) continue;
                        this.c.unifies(args[0], ASSyntax.createNumber(this.index));
                        return;
                    }
                    this.c = null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return false;
    }
}

