/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Term;

public class delete
extends DefaultInternalAction {
    private static InternalAction singleton = null;

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new delete();
        }
        return singleton;
    }

    @Override
    public int getMinArgs() {
        return 3;
    }

    @Override
    public int getMaxArgs() {
        return 4;
    }

    @Override
    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        if (args[0].isNumeric()) {
            int nextArg = 1;
            int start = (int)((NumberTerm)args[0]).solve();
            int end = start + 1;
            if (args.length == 4 && args[1].isNumeric()) {
                nextArg = 2;
                end = (int)((NumberTerm)args[1]).solve();
            }
            if (args[nextArg].isString()) {
                return un.unifies(args[nextArg + 1], this.deleteFromString(start, end, (StringTerm)args[nextArg]));
            }
            if (args[nextArg].isList()) {
                return un.unifies(args[nextArg + 1], this.deleteFromList(start, end, (ListTerm)args[nextArg]));
            }
        }
        if (args[0].isString() && args[1].isString()) {
            return un.unifies(args[2], this.deleteFromString((StringTerm)args[0], (StringTerm)args[1]));
        }
        if (args[0].isString()) {
            return un.unifies(args[2], this.deleteFromString((StringTerm)args[0], new StringTermImpl(args[1].toString())));
        }
        if (args[1].isList()) {
            return un.unifies(args[2], this.deleteFromList(args[0], (ListTerm)args[1], un.clone()));
        }
        throw new JasonException("Incorrect use of the internal action '.delete' (see documentation).");
    }

    ListTerm deleteFromList(Term element, ListTerm l, Unifier un) {
        ListTermImpl r;
        Unifier bak = un;
        ListTerm last = r = new ListTermImpl();
        for (Term t : l) {
            if (un.unifies(element, t)) {
                un = bak.clone();
                continue;
            }
            last = last.append(t.clone());
        }
        return r;
    }

    ListTerm deleteFromList(int index, int end, ListTerm l) {
        ListTermImpl r;
        ListTerm last = r = new ListTermImpl();
        int i = 0;
        for (Term t : l) {
            if (i < index || i >= end) {
                last = last.append(t.clone());
            }
            ++i;
        }
        return r;
    }

    StringTerm deleteFromString(int index, int end, StringTerm st) {
        try {
            String s = st.getString();
            return new StringTermImpl(s.substring(0, index) + s.substring(end));
        }
        catch (StringIndexOutOfBoundsException e2) {
            return st;
        }
    }

    StringTerm deleteFromString(StringTerm st1, StringTerm st2) {
        try {
            String s1 = st1.getString();
            String s2 = st2.getString();
            return new StringTermImpl(s2.replaceAll(s1, ""));
        }
        catch (StringIndexOutOfBoundsException e2) {
            System.out.println(e2);
            return st1;
        }
    }
}

