/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SourcePath {
    public static final String CRPrefix = "ClassResource:";
    protected String root = ".";
    protected String urlPrefix = null;
    protected List<String> paths = new ArrayList<String>();

    public void setRoot(String r) {
        this.root = r;
    }

    public String getRoot() {
        return this.root;
    }

    public void setUrlPrefix(String p) {
        this.urlPrefix = p;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void addPath(String cp) {
        if (cp.startsWith("\"")) {
            cp = cp.substring(1, cp.length() - 1);
        }
        if (cp.endsWith("/")) {
            cp = cp.substring(0, cp.length() - 1);
        }
        cp = cp.replaceAll("\\\\", "/");
        this.paths.add(cp);
    }

    public void addAll(SourcePath sp) {
        if (sp == null) {
            return;
        }
        for (String p : sp.paths) {
            this.paths.add(p);
        }
    }

    public void clearPaths() {
        this.paths.clear();
    }

    public List<String> getPaths() {
        ArrayList<String> r = new ArrayList<String>();
        if (this.paths.isEmpty()) {
            r.add(this.root);
        } else {
            for (String p : this.paths) {
                r.add(p);
                if (p.startsWith(".") || p.startsWith("/") || p.charAt(1) == ':' || this.root.equals(".")) continue;
                r.add(this.root + "/" + p);
            }
        }
        return r;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public String fixPath(String f) {
        return this.fixPath(f, this.urlPrefix);
    }

    public String fixPath(String f, String urlPrefix) {
        if (urlPrefix == null || urlPrefix.length() == 0) {
            if (new File(f).exists()) {
                return f;
            }
            for (String path : this.getPaths()) {
                try {
                    File newname = new File(path + "/" + f.toString());
                    if (!newname.exists()) continue;
                    return newname.getCanonicalFile().toString();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        } else {
            if (SourcePath.testURLSrc(urlPrefix + f)) {
                return urlPrefix + f;
            }
            for (String path : this.getPaths()) {
                String newname = urlPrefix + path + "/" + f;
                if (!SourcePath.testURLSrc(newname = newname.replaceAll("\\./", ""))) continue;
                return newname;
            }
        }
        return f;
    }

    private static boolean testURLSrc(String asSrc) {
        try {
            if (asSrc.startsWith(CRPrefix)) {
                SourcePath.class.getResource(asSrc.substring(CRPrefix.length())).openStream();
                return true;
            }
            new URL(asSrc).openStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.urlPrefix + ":::" + this.root + " " + this.paths;
    }
}

