/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import jason.runtime.MASConsoleGUI;
import java.io.PrintStream;
import javax.swing.JTextArea;

public class OutputStreamAdapter
extends PrintStream {
    private MASConsoleGUI masConsole;
    private JTextArea ta;
    public PrintStream originalOut = null;
    public PrintStream originalErr = null;

    public OutputStreamAdapter(MASConsoleGUI m, JTextArea t) {
        super(System.out);
        this.masConsole = m;
        this.ta = t;
    }

    public void setAsDefaultOut() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        System.setOut(this);
        System.setErr(this);
    }

    public void restoreOriginalOut() {
        if (this.originalOut != null) {
            System.setOut(this.originalOut);
        }
        if (this.originalErr != null) {
            System.setErr(this.originalErr);
        }
    }

    void append(String s) {
        if (this.masConsole != null) {
            this.masConsole.append(s);
        }
        if (this.ta != null) {
            this.ta.append(s);
            this.ta.setCaretPosition(this.ta.getDocument().getLength());
        }
    }

    @Override
    public void print(Object s) {
        this.append(s.toString());
    }

    @Override
    public void println(Object s) {
        this.append(s + "\n");
    }

    @Override
    public void print(String s) {
        this.append(s.toString());
    }

    @Override
    public void println(String s) {
        this.append(s + "\n");
    }

    @Override
    public void print(boolean arg) {
        this.append(arg + "");
    }

    @Override
    public void print(char arg0) {
        this.append(arg0 + "");
    }

    @Override
    public void print(double arg0) {
        this.append(arg0 + "");
    }

    @Override
    public void print(float arg0) {
        this.append(arg0 + "");
    }

    @Override
    public void print(int arg0) {
        this.append(arg0 + "");
    }

    @Override
    public void print(long arg0) {
        this.append(arg0 + "");
    }

    @Override
    public void println(boolean arg0) {
        this.append(arg0 + "\n");
    }

    @Override
    public void println(char arg0) {
        this.append(arg0 + "\n");
    }

    @Override
    public void println(double arg0) {
        this.append(arg0 + "\n");
    }

    @Override
    public void println(float arg0) {
        this.append(arg0 + "\n");
    }

    @Override
    public void println(int arg0) {
        this.append(arg0 + "\n");
    }

    @Override
    public void println(long arg0) {
        this.append(arg0 + "\n");
    }

    @Override
    public void println() {
        this.append("\n");
    }

    public String toString() {
        String s = "masConsole";
        if (this.masConsole == null) {
            s = "textArea";
        }
        return "OutputAdapter(" + s + ")";
    }
}

