/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

class MASColorTextPane
extends JTextPane {
    protected static final Color[] seq = new Color[]{Color.blue, Color.red, Color.gray, Color.magenta, Color.green};
    protected static int change = 0;
    protected static int lastColor = 0;
    protected Color defaultColor;

    public static synchronized Color getNextAvailableColor() {
        if (change > 0) {
            MASColorTextPane.seq[MASColorTextPane.lastColor] = change % 2 == 1 ? seq[lastColor].brighter() : seq[lastColor].darker();
        }
        Color c = seq[lastColor];
        if ((lastColor = (lastColor + 1) % seq.length) == 0) {
            ++change;
        }
        return c;
    }

    public MASColorTextPane(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public void append(String s) {
        this.append(this.defaultColor, s);
    }

    public void append(Color c, String s) {
        if (c == null) {
            c = this.defaultColor;
        }
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet as = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        try {
            this.getDocument().insertString(this.getDocument().getLength(), s, as);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

