/*
 * Decompiled with CFR 0.152.
 */
package jason.mas2j;

import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.bb.DefaultBeliefBase;
import jason.mas2j.ClassParameters;
import jason.runtime.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AgentParameters {
    public String name = null;
    public File asSource = null;
    public ClassParameters agClass = null;
    public ClassParameters bbClass = null;
    protected int nbInstances = 1;
    protected Map<String, String> options = null;
    protected List<ClassParameters> archClasses = new ArrayList<ClassParameters>();
    protected String host = null;

    public AgentParameters() {
        this.setupDefault();
    }

    public AgentParameters(AgentParameters a) {
        this();
        a.copyTo(this);
    }

    public AgentParameters copy() {
        AgentParameters newap = new AgentParameters();
        this.copyTo(newap);
        return newap;
    }

    protected void copyTo(AgentParameters newap) {
        newap.name = this.name;
        newap.asSource = new File(this.asSource.toString());
        newap.agClass = this.agClass.copy();
        newap.bbClass = this.bbClass.copy();
        newap.nbInstances = this.nbInstances;
        if (this.options != null) {
            newap.options = new HashMap<String, String>(this.options);
        }
        newap.archClasses = new ArrayList<ClassParameters>(this.archClasses);
        newap.host = this.host;
    }

    public String toString() {
        return this.getAsInMASProject();
    }

    public void setupDefault() {
        if (this.agClass == null) {
            this.agClass = new ClassParameters(Agent.class.getName());
        }
        if (this.bbClass == null) {
            this.bbClass = new ClassParameters(DefaultBeliefBase.class.getName());
        }
    }

    public ClassParameters getBBClass() {
        return this.bbClass;
    }

    public void setNbInstances(int i) {
        this.nbInstances = i;
    }

    public int getNbInstances() {
        return this.nbInstances;
    }

    public void setHost(String h) {
        this.host = h != null && h.startsWith("\"") ? h.substring(1, h.length() - 1) : h;
    }

    public String getHost() {
        return this.host;
    }

    public void setAgClass(String c) {
        if (c != null) {
            this.agClass = new ClassParameters(c);
        }
    }

    public void addArchClass(String ... cs) {
        if (cs == null) {
            return;
        }
        for (String c : cs) {
            this.archClasses.add(new ClassParameters(c));
        }
    }

    public void addArchClass(Collection<String> cs) {
        if (cs == null) {
            return;
        }
        for (String c : cs) {
            this.archClasses.add(new ClassParameters(c));
        }
    }

    public void addArchClass(ClassParameters ... cps) {
        if (cps == null) {
            return;
        }
        for (ClassParameters c : cps) {
            this.archClasses.add(c);
        }
    }

    public void insertArchClass(ClassParameters ... cps) {
        if (cps == null) {
            return;
        }
        for (ClassParameters c : cps) {
            this.archClasses.add(0, c);
        }
    }

    public List<String> getAgArchClasses() {
        ArrayList<String> all = new ArrayList<String>();
        for (ClassParameters c : this.archClasses) {
            all.add(c.getClassName());
        }
        return all;
    }

    public void setBB(ClassParameters c) {
        if (c != null) {
            this.bbClass = c;
        }
    }

    public void setOptions(Map<String, String> m) {
        for (String k : m.keySet()) {
            this.addOption(k, m.get(k));
        }
    }

    public void addOption(String k, String vl) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(k, vl);
    }

    public String getOption(String key) {
        if (this.options == null) {
            return null;
        }
        return this.options.get(key);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getAsInMASProject() {
        StringBuilder s = new StringBuilder(this.name + " ");
        if (this.asSource != null && !this.asSource.getName().startsWith(this.name)) {
            s.append(this.asSource + " ");
        }
        if (this.options != null && !this.options.isEmpty()) {
            s.append("[");
            Iterator<String> i = this.options.keySet().iterator();
            while (i.hasNext()) {
                String k = i.next();
                s.append(k + "=" + this.options.get(k));
                if (!i.hasNext()) continue;
                s.append(", ");
            }
            s.append("] ");
        }
        for (ClassParameters c : this.archClasses) {
            if (c.getClassName().length() <= 0 || c.getClassName().equals(AgArch.class.getName())) continue;
            s.append("agentArchClass " + c + " ");
        }
        if (this.agClass != null && this.agClass.getClassName().length() > 0 && !this.agClass.getClassName().equals(Agent.class.getName())) {
            s.append("agentClass " + this.agClass + " ");
        }
        if (this.bbClass != null && this.bbClass.getClassName().length() > 0 && !this.bbClass.getClassName().equals(DefaultBeliefBase.class.getName())) {
            s.append("beliefBaseClass " + this.bbClass + " ");
        }
        if (this.nbInstances > 1) {
            s.append("#" + this.nbInstances + " ");
        }
        if (this.host != null && this.host.length() > 0) {
            s.append("at \"" + this.host + "\"");
        }
        return s.toString().trim() + ";";
    }

    public Settings getAsSetts(boolean debug, boolean forceSync) {
        Settings stts = new Settings();
        if (this.options != null) {
            HashMap<String, Object> opt = new HashMap<String, Object>();
            for (String key : this.options.keySet()) {
                opt.put(key, this.options.get(key));
            }
            if (!opt.isEmpty()) {
                stts.setOptions(opt);
            }
        }
        if (debug) {
            stts.setVerbose(2);
        }
        if (forceSync || debug) {
            stts.setSync(true);
        }
        stts.addOption("project-parameter", this);
        return stts;
    }

    public String getAgName() {
        return this.name;
    }
}

