/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import jason.jeditplugin.JasonID;
import jason.mas2j.AgentParameters;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.ParseException;
import jason.mas2j.parser.mas2j;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import sidekick.Asset;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;

public class JasonProjectSideKickParser
extends SideKickParser {
    public static final String ID = "mas2j";
    static Set<JasonID> jasonPluginInstance = new HashSet<JasonID>();
    SideKickParsedData pd = null;
    private static Icon AG_ICON;
    private static Icon INFRA_ICON;
    private static Icon ENV_ICON;
    private static final int AG_TYPE = 1;
    private static final int INFRA_TYPE = 2;
    private static final int ENV_TYPE = 3;

    public JasonProjectSideKickParser() {
        super(ID);
    }

    public static void addPluginInstance(JasonID p) {
        jasonPluginInstance.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buf, DefaultErrorSource errorSource) {
        String text;
        try {
            buf.readLock();
            text = buf.getText(0, buf.getLength());
        }
        finally {
            buf.readUnlock();
        }
        try {
            mas2j parser = new mas2j(new StringReader(text));
            MAS2JProject project = parser.mas();
            project.setDirectory(buf.getDirectory());
            project.fixAgentsSrc();
            this.pd = new SideKickParsedData(buf.getName());
            this.pd.root.add(new ProjectAsset("Infrastructure: ", project.getInfrastructure().toString(), buf, 2).createTreeNode());
            if (project.getEnvClass() != null) {
                this.pd.root.add(new ProjectAsset("Environment: ", project.getEnvClass().toString(), buf, 3).createTreeNode());
            }
            for (JasonID jid : jasonPluginInstance) {
                jid.listModel.clear();
            }
            for (AgentParameters ap : project.getAgents()) {
                this.pd.root.add(new ProjectAsset("", ap.name + " (" + ap.asSource + ")", buf, 1).createTreeNode());
                for (JasonID jid : jasonPluginInstance) {
                    jid.listModel.addElement(ap);
                }
            }
        }
        catch (ParseException ex) {
            JasonProjectSideKickParser.addError(ex, errorSource, buf.getPath());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return this.pd;
    }

    public static void addError(ParseException ex, DefaultErrorSource errorSource, String path) {
        if (ex.currentToken != null && ex.currentToken.next != null && errorSource != null) {
            int line = ex.currentToken.next.beginLine - 1;
            if (line < 0) {
                line = 0;
            }
            errorSource.addError(new DefaultErrorSource.DefaultError((ErrorSource)errorSource, 0, path, line, 0, 0, ex.toString()));
        }
    }

    public String toString() {
        return ID;
    }

    class ProjectAsset
    extends Asset {
        int type;

        public ProjectAsset(String pre, String vl, Buffer buf, int type) {
            super(pre + vl);
            this.type = 1;
            this.start = this.toPos(buf, vl);
            this.end = this.toPos(buf, vl);
            this.type = type;
        }

        public Icon getIcon() {
            switch (this.type) {
                case 2: {
                    if (INFRA_ICON == null) {
                        INFRA_ICON = GUIUtilities.loadIcon((String)"normal.gif");
                    }
                    return INFRA_ICON;
                }
                case 1: {
                    if (AG_ICON == null) {
                        AG_ICON = GUIUtilities.loadIcon((String)"Plus.png");
                    }
                    return AG_ICON;
                }
                case 3: {
                    if (ENV_ICON == null) {
                        ENV_ICON = GUIUtilities.loadIcon((String)"arrow1.png");
                    }
                    return ENV_ICON;
                }
            }
            return null;
        }

        public String getShortString() {
            return this.name;
        }

        public String getLongString() {
            return this.name;
        }

        private Position toPos(Buffer buffer, String p) {
            String text = buffer.getText(0, buffer.getLength());
            int pos = text.indexOf(p);
            if (pos >= 0) {
                return buffer.createPosition(pos);
            }
            return buffer.createPosition(0);
        }

        public DefaultMutableTreeNode createTreeNode() {
            return new DefaultMutableTreeNode((Object)this, true);
        }
    }
}

