/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import jason.architecture.MindInspectorWeb;
import jason.asSyntax.parser.as2j;
import jason.infra.MASLauncherInfraTier;
import jason.infra.RunProjectListener;
import jason.infra.centralised.CentralisedMASLauncherAnt;
import jason.jeditplugin.AboutGUI;
import jason.jeditplugin.AgentSpeakSideKickParser;
import jason.jeditplugin.JasonProjectSideKickParser;
import jason.jeditplugin.NewAgentGUI;
import jason.jeditplugin.NewEnvironmentGUI;
import jason.jeditplugin.NewInternalActionGUI;
import jason.jeditplugin.NewProjectGUI;
import jason.mas2j.AgentParameters;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.ParseException;
import jason.mas2j.parser.TokenMgrError;
import jason.mas2j.parser.mas2j;
import jason.runtime.OutputStreamAdapter;
import jason.util.CheckVersion;
import jason.util.Config;
import jason.util.asl2html;
import jason.util.asl2tex;
import jason.util.asl2xml;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.AnimatedIcon;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class JasonID
extends JPanel
implements EBComponent,
RunProjectListener {
    private static final long serialVersionUID = 1L;
    View view;
    OutputStreamAdapter myOut;
    JTextArea textArea;
    AnimatedIcon animation;
    JButton btStop;
    JButton btRun;
    JButton btDebug;
    DefaultListModel listModel = new DefaultListModel();
    JList lstAgs = new JList(this.listModel);
    DefaultErrorSource errorSource = null;
    MASLauncherInfraTier masLauncher;

    public JasonID(View view, String position) {
        super(new BorderLayout());
        this.view = view;
        this.add("North", this.createToolBar());
        boolean floating = position.equals("floating");
        if (floating) {
            this.setPreferredSize(new Dimension(500, 250));
        }
        this.textArea = new JTextArea(5, 10);
        this.textArea.setEditable(false);
        this.textArea.setText("Further Jason functionalities are available in the menu Plugin->Jason.");
        JPanel pane = new JPanel(new BorderLayout());
        pane.add("Center", new JScrollPane(this.textArea));
        pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Jason console", 1, 2));
        this.add("Center", pane);
        JPanel pLst = new JPanel(new BorderLayout());
        pLst.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Project agents", 1, 2));
        pLst.add("Center", new JScrollPane(this.lstAgs));
        this.lstAgs.setSelectionMode(0);
        this.lstAgs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                JasonID.this.openAgentBuffer((AgentParameters)JasonID.this.lstAgs.getSelectedValue());
            }
        });
        pLst.setPreferredSize(new Dimension(120, 50));
        this.add("East", pLst);
        this.myOut = new OutputStreamAdapter(null, this.textArea);
        this.myOut.setAsDefaultOut();
        JasonProjectSideKickParser.addPluginInstance(this);
        new CheckVersion().start();
        new Thread(){

            @Override
            public void run() {
                try {
                    2.sleep(4000L);
                    MindInspectorWeb.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
        this.stopMAS();
    }

    private JPanel createToolBar() {
        JPanel toolBar = new JPanel();
        toolBar.setLayout(new BoxLayout(toolBar, 0));
        JLabel animationLabel = new JLabel();
        animationLabel.setBorder(new EmptyBorder(2, 3, 2, 3));
        Toolkit toolkit = this.getToolkit();
        this.animation = new AnimatedIcon(toolkit.getImage(JasonID.class.getResource("/images/Blank.png")), new Image[]{toolkit.getImage(JasonID.class.getResource("/images/Active1.png")), toolkit.getImage(JasonID.class.getResource("/images/Active2.png")), toolkit.getImage(JasonID.class.getResource("/images/Active3.png")), toolkit.getImage(JasonID.class.getResource("/images/Active4.png"))}, 10, (Component)animationLabel);
        animationLabel.setIcon((Icon)this.animation);
        toolBar.add(animationLabel);
        this.btRun = this.createToolBarButton("Run MAS", new ImageIcon(JasonID.class.getResource("/images/run.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JasonID.this.runProject();
            }
        });
        toolBar.add(this.btRun);
        this.btDebug = this.createToolBarButton("Debug MAS", new ImageIcon(JasonID.class.getResource("/images/debug.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JasonID.this.debugProject();
            }
        });
        toolBar.add(this.btDebug);
        this.btStop = this.createToolBarButton("Stop MAS", new ImageIcon(JasonID.class.getResource("/images/suspend.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JasonID.this.stopMAS();
            }
        });
        this.btStop.setEnabled(false);
        toolBar.add(this.btStop);
        toolBar.add(new JLabel(" | "));
        toolBar.add(this.createToolBarButton("Open Project", new ImageIcon(JasonID.class.getResource("/images/openProject.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VFSFileChooserDialog dialog = new VFSFileChooserDialog(JasonID.this.view, ".", 0, false);
                if (dialog.getSelectedFiles() != null && dialog.getSelectedFiles().length > 0) {
                    jEdit.openFile((View)JasonID.this.view, (String)dialog.getSelectedFiles()[0].toString());
                }
            }
        }));
        toolBar.add(this.createToolBarButton("New Project", new ImageIcon(JasonID.class.getResource("/images/newProject.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JasonID.this.newProject();
            }
        }));
        toolBar.add(this.createToolBarButton("Add agent in project", new ImageIcon(JasonID.class.getResource("/images/newAgent.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JasonID.this.newAg();
            }
        }));
        toolBar.add(this.createToolBarButton("Create Environment", new ImageIcon(JasonID.class.getResource("/images/createEnv.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JasonID.this.createEnv();
            }
        }));
        toolBar.add(this.createToolBarButton("Create Internal Action", new ImageIcon(JasonID.class.getResource("/images/createIA.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JasonID.this.newIA();
            }
        }));
        toolBar.add(new JLabel(" | "));
        toolBar.add(this.createToolBarButton("Clear panel", new ImageIcon(JasonID.class.getResource("/images/clear.gif")), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JasonID.this.textArea.setText("");
            }
        }));
        this.add(Box.createGlue());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)toolBar, "East");
        JButton about = new JButton("<html><center>about<br><i><b>Jason</b></i></center></html>", new ImageIcon(JasonID.class.getResource("/images/Jason-GMoreau-Small-Icon.jpg")));
        about.setFont(new Font("Arial", 0, 14));
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AboutGUI.show((JFrame)JasonID.this.view);
            }
        });
        JPanel pAbt = new JPanel();
        pAbt.add(about);
        p.add((Component)pAbt, "West");
        return p;
    }

    protected JButton createToolBarButton(String toolTip, Icon icon, ActionListener act) {
        RolloverButton button = new RolloverButton(icon);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setRequestFocusEnabled(false);
        button.setToolTipText(toolTip);
        button.setRequestFocusEnabled(false);
        button.addActionListener(act);
        return button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openAgentBuffer(AgentParameters ap) {
        block7: {
            try {
                if (ap == null || ap.asSource == null) {
                    return;
                }
                Buffer projectb = this.getProjectBuffer();
                String file = ap.asSource.toString();
                if (file.indexOf(47) < 0 && file.indexOf(92) < 0) {
                    file = projectb.getDirectory() + "/" + file;
                }
                boolean newFile = !new File(file = new File(file).getAbsolutePath()).exists();
                Buffer nb = jEdit.openFile((View)this.view, (String)file);
                if (!newFile) break block7;
                try {
                    ap.asSource = new File(projectb.getDirectory() + ap.name + "." + "asl");
                    String agcode = Config.get().getTemplate("agent");
                    agcode = agcode.replace("<AG_NAME>", ap.getAgName());
                    agcode = agcode.replace("<PROJECT_NAME>", projectb.getName());
                    nb.writeLock();
                    nb.insert(0, agcode);
                    nb.save(this.view, file);
                }
                finally {
                    nb.writeUnlock();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void handleMessage(EBMessage message) {
        if (message == null) {
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    private Buffer getProjectBuffer() {
        if (this.view.getBuffer().getPath().endsWith("mas2j")) {
            return this.view.getBuffer();
        }
        Buffer[] bufs = jEdit.getBuffers();
        for (int i = 0; i < bufs.length; ++i) {
            if (!bufs[i].getPath().endsWith("mas2j")) continue;
            return bufs[i];
        }
        return null;
    }

    Buffer getProjectBuffer(String name) {
        Buffer[] bufs = jEdit.getBuffers();
        for (int i = 0; i < bufs.length; ++i) {
            if (!bufs[i].getPath().endsWith(name)) continue;
            return bufs[i];
        }
        return null;
    }

    private void saveAll() {
        Buffer[] bufs = jEdit.getBuffers();
        for (int i = 0; i < bufs.length; ++i) {
            if (!bufs[i].isDirty()) continue;
            bufs[i].save(this.view, null);
        }
    }

    private MAS2JProject parseProject(Buffer projectBufffer) {
        try {
            String text;
            this.textArea.append("Parsing project file... ");
            try {
                projectBufffer.readLock();
                text = projectBufffer.getText(0, projectBufffer.getLength());
            }
            finally {
                projectBufffer.readUnlock();
            }
            mas2j parser = new mas2j(new StringReader(text));
            MAS2JProject project = parser.mas();
            project.setDirectory(projectBufffer.getDirectory());
            project.setProjectFile(new File(projectBufffer.getPath()));
            project.fixAgentsSrc();
            this.textArea.append(" parsed successfully!\n");
            return project;
        }
        catch (ParseException ex) {
            this.textArea.append("\nmas2j: syntactic errors found... \n" + ex + "\n");
            JasonProjectSideKickParser.addError(ex, this.errorSource, projectBufffer.getPath());
        }
        catch (TokenMgrError ex) {
            this.textArea.append("\nmas2j: lexical errors found... \n" + ex + "\n");
        }
        catch (Exception ex) {
            this.textArea.append("Error: " + ex);
            ex.printStackTrace();
        }
        return null;
    }

    protected boolean parseProjectAS(MAS2JProject project) {
        File asFile2 = null;
        try {
            for (File asFile2 : project.getAllASFiles()) {
                try {
                    this.textArea.append("Parsing AgentSpeak file '" + asFile2.getName() + "'...");
                    as2j parser = new as2j(new FileReader(asFile2));
                    parser.agent(null);
                    this.textArea.append(" parsed successfully!\n");
                }
                catch (FileNotFoundException ex) {
                    this.textArea.append(" error: file '" + asFile2 + "' not found!");
                    return false;
                }
            }
            return true;
        }
        catch (jason.asSyntax.parser.ParseException ex) {
            this.textArea.append("\nas2j: syntactic errors found... \n" + ex + "\n");
            AgentSpeakSideKickParser.addError(ex, this.errorSource, asFile2.getAbsolutePath());
            DockableWindowManager d = this.view.getDockableWindowManager();
            if (!d.isDockableWindowVisible("error-list")) {
                d.addDockableWindow("error-list");
            }
        }
        catch (TokenMgrError ex) {
            this.textArea.append("\nmas2j: lexical errors found... \n" + ex + "\n");
        }
        catch (Exception ex) {
            this.textArea.append("\nError: " + ex);
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void masFinished() {
        this.animation.stop();
        this.btStop.setEnabled(false);
        this.btRun.setEnabled(true);
        this.btDebug.setEnabled(true);
    }

    public void runProject(final boolean debug) {
        final Buffer b = this.getProjectBuffer();
        if (b == null) {
            this.textArea.setText("There is no Jason project opened!");
            return;
        }
        this.textArea.setText("Launching " + b.getName() + "\n");
        if (this.errorSource == null) {
            this.errorSource = new DefaultErrorSource("JasonIDE");
            ErrorSource.registerErrorSource((ErrorSource)this.errorSource);
        }
        this.errorSource.clear();
        this.saveAll();
        new Thread(){

            @Override
            public void run() {
                Buffer[] bufs = jEdit.getBuffers();
                int max2 = 1;
                for (int i = 0; i < bufs.length && max2 < 20; ++i) {
                    if (!bufs[i].isPerformingIO()) continue;
                    --i;
                    ++max2;
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MAS2JProject project = JasonID.this.parseProject(b);
                if (project == null) {
                    return;
                }
                JasonID.this.animation.start();
                JasonID.this.btStop.setEnabled(true);
                JasonID.this.btRun.setEnabled(false);
                JasonID.this.btDebug.setEnabled(false);
                try {
                    String antLib;
                    String jasonJar;
                    if (JasonID.this.masLauncher != null) {
                        JasonID.this.masLauncher.stopMAS();
                    }
                    if (!Config.checkJar(jasonJar = Config.get().getJasonJar())) {
                        System.err.println("The path to the jason.jar file (" + jasonJar + ") was not correctly set: the MAS may not run. Go to menu Plugins->Plugins Options->Jason to configure the path.");
                        return;
                    }
                    String javaHome = Config.get().getJavaHome();
                    if (!Config.checkJavaHomePath(javaHome)) {
                        System.err.println("The Java JDK directory (" + javaHome + ") was not correctly set: the MAS may not run. Go to the Plugins->Options->Jason menu to configure the path.");
                    }
                    if (!Config.checkAntLib(antLib = Config.get().getAntLib())) {
                        System.err.println("The ant lib directory (" + antLib + ") was not correctly set: the MAS may not run. Go to the Plugins->Options->Jason menu to configure the path.");
                        return;
                    }
                    JasonID.this.masLauncher = project.getInfrastructureFactory().createMASLauncher();
                    JasonID.this.masLauncher.setProject(project);
                    JasonID.this.masLauncher.setListener(JasonID.this);
                    if (JasonID.this.masLauncher.writeScripts(debug, true)) {
                        new Thread((Runnable)JasonID.this.masLauncher, "MAS-Launcher").start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public void runProject() {
        this.runProject(false);
    }

    public void debugProject() {
        this.runProject(true);
    }

    public void stopMAS() {
        this.animation.stop();
        this.btStop.setEnabled(false);
        this.btRun.setEnabled(true);
        this.btDebug.setEnabled(true);
        if (this.masLauncher != null) {
            this.masLauncher.stopMAS();
            this.masLauncher = null;
        }
    }

    public void newProject() {
        new NewProjectGUI("New Jason Project", this.view, this);
    }

    public void newAg() {
        Buffer b = this.getProjectBuffer();
        if (b == null) {
            this.textArea.setText("There is no Jason project opened to add an agent to: create a new project first.");
        } else {
            new NewAgentGUI("Adding an agent to project " + b.getName(), b, this.view, b.getDirectory());
        }
    }

    public void createEnv() {
        Buffer b = this.getProjectBuffer();
        if (b == null) {
            this.textArea.setText("There is no Jason project opened: create a new project first.");
        } else if (b.getText(0, b.getLength()).indexOf("environment") > 0) {
            this.textArea.setText("Your project already has an environment definition!");
        } else {
            new NewEnvironmentGUI("Creating an environment for project " + b.getName(), b, this.view);
        }
    }

    public void newIA() {
        Buffer b = this.getProjectBuffer();
        if (b == null) {
            this.textArea.setText("There is no Jason project opened: create a new project first.");
        } else {
            new NewInternalActionGUI("Creating new internal action for project " + b.getName(), b, this.view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editLog() {
        block7: {
            Buffer curBuf = this.getProjectBuffer();
            if (curBuf == null) {
                this.textArea.setText("There is no Jason project opened: you cannot edit logging properties.");
                return;
            }
            try {
                File f = new File(curBuf.getDirectory() + File.separator + "logging.properties");
                if (f.exists()) {
                    jEdit.openFile((View)this.view, (String)f.getAbsolutePath());
                    break block7;
                }
                String logText = Config.get().getTemplate("logging.properties");
                Buffer b = jEdit.openFile((View)this.view, (String)f.getAbsolutePath());
                try {
                    b.writeLock();
                    b.insert(0, logText);
                    b.save(this.view, f.getAbsolutePath());
                }
                finally {
                    b.writeUnlock();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void asl2html() {
        this.asl2txt(new asl2html(), ".html");
    }

    public void asl2tex() {
        this.asl2txt(new asl2tex(), ".tex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asl2txt(asl2xml transformer, String ext) {
        Buffer buf = this.view.getBuffer();
        if (!buf.getPath().endsWith("asl")) {
            this.textArea.setText("\n** The current buffer is not an AgentSpeak source!");
            return;
        }
        this.textArea.setText("");
        try {
            String aslcode;
            try {
                buf.readLock();
                aslcode = buf.getText(0, buf.getLength());
            }
            finally {
                buf.readUnlock();
            }
            String htmlcode = transformer.transform(aslcode);
            Buffer b = jEdit.openFile((View)this.view, (String)(buf.getPath() + ext));
            try {
                b.writeLock();
                b.insert(0, htmlcode);
                b.save(this.view, buf.getPath() + ".html");
            }
            finally {
                b.writeUnlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void runAntTask(String task) {
        Buffer b = this.getProjectBuffer();
        if (b == null) {
            this.textArea.setText("There is no Jason project opened!");
            return;
        }
        MAS2JProject project = this.parseProject(b);
        if (project == null) {
            return;
        }
        CentralisedMASLauncherAnt script = new CentralisedMASLauncherAnt(task);
        script.setProject(project);
        if (script.writeScripts(false, true)) {
            new Thread((Runnable)script, "Ant-Task").start();
        }
    }
}

