/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import jason.asSemantics.Agent;
import jason.asSyntax.Plan;
import jason.asSyntax.parser.ParseException;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import sidekick.Asset;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;

public class AgentSpeakSideKickParser
extends SideKickParser {
    public static final String ID = "asl";
    SideKickParsedData pd = null;
    private static Icon PLAN_ICON;

    public AgentSpeakSideKickParser() {
        super(ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buf, DefaultErrorSource errorSource) {
        String text;
        try {
            buf.readLock();
            text = buf.getText(0, buf.getLength());
        }
        finally {
            buf.readUnlock();
        }
        try {
            as2j parser = new as2j(new StringReader(text));
            Agent ag = new Agent();
            ag.initAg();
            parser.agent(ag);
            this.pd = new SideKickParsedData(buf.getName());
            for (Plan p : ag.getPL()) {
                DefaultMutableTreeNode node = new PlanAsset(p, buf).createTreeNode();
                this.pd.root.add(node);
            }
        }
        catch (ParseException ex) {
            AgentSpeakSideKickParser.addError(ex, errorSource, buf.getPath());
        }
        catch (Exception e2) {
            System.out.println("Error in AS SideKick:" + e2);
            e2.printStackTrace();
        }
        return this.pd;
    }

    public static void addError(ParseException ex, DefaultErrorSource errorSource, String path) {
        if (ex.currentToken != null && ex.currentToken.next != null && errorSource != null) {
            int line = ex.currentToken.next.beginLine - 1;
            if (line < 0) {
                line = 0;
            }
            errorSource.addError(new DefaultErrorSource.DefaultError((ErrorSource)errorSource, 0, path, line, 0, 0, ex.toString()));
        }
    }

    public String toString() {
        return ID;
    }

    class PlanAsset
    extends Asset {
        private Plan plan;

        public PlanAsset(Plan p, Buffer buf) {
            super(p.getTrigger().toString());
            this.plan = p;
            this.start = this.toPos(buf, p.getSrcInfo().getBeginSrcLine());
            this.end = this.toPos(buf, p.getSrcInfo().getEndSrcLine());
        }

        public Icon getIcon() {
            if (PLAN_ICON == null) {
                PLAN_ICON = new ImageIcon(AgentSpeakSideKickParser.class.getResource("/images/plan.png"));
            }
            return PLAN_ICON;
        }

        public String getShortString() {
            return this.name;
        }

        public String getLongString() {
            return this.plan.toASString();
        }

        private Position toPos(Buffer buffer, int line) {
            if (line - 1 > buffer.getLineCount()) {
                return buffer.createPosition(buffer.getLength() - 1);
            }
            int offset = buffer.getLineStartOffset(line - 1);
            if (offset >= buffer.getLength()) {
                return buffer.createPosition(buffer.getLength() - 1);
            }
            return buffer.createPosition(offset);
        }

        public DefaultMutableTreeNode createTreeNode() {
            return new DefaultMutableTreeNode((Object)this, true);
        }
    }
}

