/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.repl;

import jason.JasonException;
import jason.asSemantics.Agent;
import jason.asSemantics.IntendedMeans;
import jason.asSemantics.Intention;
import jason.asSemantics.Option;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Trigger;
import jason.infra.repl.clear;
import jason.infra.repl.mi;
import jason.infra.repl.print_unifier;
import jason.infra.repl.verbose;

public abstract class ReplAg
extends Agent {
    String[] replCmds = new String[]{clear.class.getName(), mi.class.getName()};
    int cmdCounter = 0;

    @Override
    public void initAg() {
        super.initAg();
    }

    @Override
    public void load(String asSrc) throws JasonException {
        super.load(null);
    }

    void execCmd(String sCmd) {
        try {
            if (sCmd.endsWith(".")) {
                sCmd = sCmd.substring(0, sCmd.length() - 1);
            }
            for (String c : this.replCmds) {
                if (!c.endsWith(sCmd) || !sCmd.startsWith(".")) continue;
                sCmd = c;
                break;
            }
            if (sCmd.startsWith(".verbose")) {
                sCmd = verbose.class.getPackage().getName() + sCmd;
            }
            sCmd = sCmd + ";" + print_unifier.class.getName();
            PlanBody lCmd = ASSyntax.parsePlanBody(sCmd);
            Trigger te = ASSyntax.parseTrigger("+!run_repl_expr");
            Intention i = new Intention();
            i.push(new IntendedMeans(new Option(new Plan(null, te, null, lCmd), new Unifier()), te));
            this.getTS().getC().addIntention(i);
            ++this.cmdCounter;
            this.clear();
            this.getTS().getUserAgArch().wake();
        }
        catch (Exception e2) {
            this.print("Error parsing " + sCmd + "\n" + e2);
        }
    }

    public void print(String s) {
        System.out.println(s + "\n");
    }

    public void clear() {
    }
}

