/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.UnreadableException;
import jade.util.Logger;
import jade.wrapper.ContainerController;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Message;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.infra.jade.JadeAg;
import jason.infra.jade.JadeAgArch;
import jason.infra.jade.JadeEnvironment;
import jason.infra.jade.JadeRuntimeServices;
import jason.infra.jade.RunJadeMAS;
import jason.mas2j.AgentParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JasonBridgeArch
extends AgArch {
    JadeAgArch jadeAg;
    AID environmentAID = null;
    java.util.logging.Logger logger = Logger.getMyLogger((String)this.getClass().getName());
    private Map<String, ActionExec> myPA = new HashMap<String, ActionExec>();
    private boolean consultEnv = false;

    public JasonBridgeArch(JadeAgArch jadeAg) {
        this.jadeAg = jadeAg;
        this.logger = Logger.getMyLogger((String)(this.getClass().getName() + "." + this.getAgName()));
    }

    public void init(AgentParameters ap) throws Exception {
        jason.asSemantics.Agent.create(this, ap.agClass.getClassName(), ap.getBBClass(), ap.asSource.getAbsolutePath(), ap.getAsSetts(false, false));
        this.insertAgArch(this);
        this.createCustomArchs(ap.getAgArchClasses());
        if (this.getTS().getSettings().verbose() >= 0) {
            this.logger.setLevel(this.getTS().getSettings().logLevel());
        }
    }

    @Override
    public void wake() {
        this.jadeAg.wakeUp();
    }

    @Override
    public void stop() {
        this.getTS().getAg().stopAg();
        super.stop();
    }

    @Override
    public String getAgName() {
        return this.jadeAg.getLocalName();
    }

    @Override
    public boolean canSleep() {
        return this.jadeAg.getCurQueueSize() == 0 && this.isRunning();
    }

    public List<Literal> perceive() {
        super.perceive();
        if (!this.isRunning()) {
            return null;
        }
        if (this.getEnvironmentAg() == null) {
            return null;
        }
        ListTerm percepts = null;
        try {
            ACLMessage askMsg = new ACLMessage(13);
            askMsg.addReceiver(this.environmentAID);
            askMsg.setOntology(JadeEnvironment.perceptionOntology);
            askMsg.setContent("getPercepts");
            ACLMessage r = this.jadeAg.ask(askMsg);
            if (r != null && r.getContent().startsWith("[")) {
                percepts = ListTermImpl.parseList(r.getContent());
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error in perceive.", e2);
        }
        return percepts;
    }

    public JadeAgArch getJadeAg() {
        return this.jadeAg;
    }

    @Override
    public void sendMsg(Message m) throws Exception {
        this.jadeAg.sendMsg(m);
    }

    @Override
    public void broadcast(Message m) throws Exception {
        this.jadeAg.broadcast(m);
    }

    @Override
    public void checkMail() {
        ACLMessage m = null;
        do {
            try {
                Object propCont;
                m = this.jadeAg.receive();
                if (m == null) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Received message: " + m);
                }
                if (this.isActionFeedback(m)) continue;
                String ilForce = JadeAg.aclPerformativeToKqml(m);
                String sender = m.getSender().getLocalName();
                String replyWith = m.getReplyWith();
                String irt = m.getInReplyTo();
                if (replyWith != null && replyWith.length() > 0) {
                    if (m.getConversationId() != null) {
                        this.jadeAg.putConversationId(replyWith, m.getConversationId());
                    }
                } else {
                    replyWith = "noid";
                }
                if ((propCont = this.translateContentToJason(m)) == null) continue;
                Message im = new Message(ilForce, sender, this.getAgName(), propCont, replyWith);
                if (irt != null) {
                    im.setInReplyTo(irt);
                }
                this.getTS().getC().getMailBox().add(im);
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error receiving message.", e2);
            }
        } while (m != null);
    }

    protected Object translateContentToJason(ACLMessage m) {
        Serializable propCont = null;
        try {
            propCont = m.getContentObject();
            if (propCont instanceof String) {
                try {
                    propCont = ASSyntax.parseTerm((String)((Object)propCont));
                }
                catch (Exception exception) {}
            }
        }
        catch (UnreadableException unreadableException) {
            // empty catch block
        }
        if (propCont == null) {
            try {
                propCont = ASSyntax.parseTerm(m.getContent());
            }
            catch (Exception e2) {
                propCont = new StringTermImpl(m.getContent());
            }
        }
        return propCont;
    }

    @Override
    public void act(ActionExec action) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getEnvironmentAg() == null) {
            return;
        }
        try {
            Structure acTerm = action.getActionTerm();
            this.logger.fine("doing: " + acTerm);
            String rw = "id" + this.jadeAg.incReplyWithId();
            ACLMessage m = new ACLMessage(16);
            m.addReceiver(this.environmentAID);
            m.setOntology(JadeEnvironment.actionOntology);
            m.setContent(((Object)acTerm).toString());
            m.setReplyWith(rw);
            this.myPA.put(rw, action);
            this.jadeAg.send(m);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error sending action " + action, e2);
        }
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new JadeRuntimeServices((ContainerController)this.jadeAg.getContainerController(), this.jadeAg);
    }

    private AID getEnvironmentAg() {
        if (!this.consultEnv) {
            DFAgentDescription template = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setType("jason");
            sd.setName(RunJadeMAS.environmentName);
            template.addServices(sd);
            try {
                DFAgentDescription[] ans = DFService.search((Agent)this.jadeAg, (DFAgentDescription)template);
                if (ans.length > 0) {
                    this.environmentAID = ans[0].getName();
                }
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error getting environment from DF.", e2);
            }
            this.consultEnv = true;
        }
        return this.environmentAID;
    }

    boolean isActionFeedback(ACLMessage m) {
        if (m.getOntology() != null && m.getOntology().equals(JadeEnvironment.actionOntology)) {
            String irt = m.getInReplyTo();
            if (irt != null) {
                ActionExec a = this.myPA.remove(irt);
                if (a != null) {
                    a.setResult(m.getContent().equals("ok"));
                    this.actionExecuted(a);
                } else {
                    this.logger.log(Level.SEVERE, "Error: received feedback for an Action that is not pending. The message is " + m);
                }
            }
            return true;
        }
        return false;
    }
}

