/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jason.JasonException;
import jason.architecture.AgArch;
import jason.infra.jade.JadeAgArch;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JadeRuntimeServices
implements RuntimeServicesInfraTier {
    private static Logger logger = Logger.getLogger(JadeRuntimeServices.class.getName());
    private ContainerController cc;
    private Agent jadeAgent;

    JadeRuntimeServices(ContainerController cc, Agent ag) {
        this.cc = cc;
        this.jadeAgent = ag;
    }

    @Override
    public String createAgent(String agName, String agSource, String agClass, List<String> archClasses, ClassParameters bbPars, Settings stts, jason.asSemantics.Agent father) throws Exception {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating jade agent " + agName + "from source " + agSource + "(agClass=" + agClass + ", archClass=" + archClasses + ", settings=" + stts);
            }
            AgentParameters ap = new AgentParameters();
            ap.setAgClass(agClass);
            ap.addArchClass(archClasses);
            ap.setBB(bbPars);
            ap.asSource = new File(agSource);
            if (stts == null) {
                stts = new Settings();
            }
            this.cc.createNewAgent(agName, JadeAgArch.class.getName(), new Object[]{ap, false, false}).start();
            return agName;
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error creating agent " + agName, e2);
            return null;
        }
    }

    @Override
    public void startAgent(String agName) {
    }

    @Override
    public AgArch clone(jason.asSemantics.Agent source, List<String> archClasses, String agName) throws JasonException {
        throw new JasonException("clone for JADE is not implemented!");
    }

    @Override
    public Set<String> getAgentsNames() {
        if (this.jadeAgent == null) {
            return null;
        }
        try {
            HashSet<String> ags = new HashSet<String>();
            DFAgentDescription template = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setType("jason");
            sd.setName(JadeAgArch.dfName);
            template.addServices(sd);
            DFAgentDescription[] ans = DFService.search((Agent)this.jadeAgent, (DFAgentDescription)template);
            for (int i = 0; i < ans.length; ++i) {
                ags.add(ans[i].getName().getLocalName());
            }
            return ags;
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error getting agents' name", e2);
            return null;
        }
    }

    @Override
    public int getAgentsQty() {
        try {
            return this.getAgentsNames().size();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error getting agents qty", e2);
            return 0;
        }
    }

    @Override
    public boolean killAgent(String agName, String byAg) {
        try {
            AgentController ac = this.cc.getAgent(agName);
            if (ac != null) {
                ac.kill();
                return true;
            }
            logger.warning("Agent " + agName + " does not exist!");
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error killing agent", e2);
        }
        return false;
    }

    @Override
    public void stopMAS() throws Exception {
        if (this.cc != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        JadeRuntimeServices.this.cc.getPlatformController().kill();
                    }
                    catch (ControllerException e2) {
                        e2.printStackTrace();
                    }
                }
            }.start();
        }
    }
}

