/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.jade.JadeAg;
import jason.infra.jade.JadeExecutionControl;
import jason.infra.jade.JasonBridgeArch;
import jason.infra.jade.RunJadeMAS;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.ParseException;
import jason.mas2j.parser.mas2j;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import org.w3c.dom.Document;

public class JadeAgArch
extends JadeAg {
    public static String dfName = "j_agent";
    private static final long serialVersionUID = 1L;
    protected JasonBridgeArch jasonBridgeAgArch;
    AID controllerAID = new AID(RunJadeMAS.controllerName, false);
    Behaviour tsBehaviour;
    private static boolean cartagoStarted = false;
    private MessageTemplate ts = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchContent((String)"agState"), (MessageTemplate)MessageTemplate.MatchOntology((String)JadeExecutionControl.controllerOntology));
    private MessageTemplate tc = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchContent((String)"performCycle"), (MessageTemplate)MessageTemplate.MatchOntology((String)JadeExecutionControl.controllerOntology));

    protected void setup() {
        if (BaseCentralisedMAS.getRunner() != null) {
            BaseCentralisedMAS.getRunner().setupLogger();
        }
        this.logger = Logger.getMyLogger((String)(((Object)((Object)this)).getClass().getName() + "." + this.getLocalName()));
        this.logger.info("starting " + this.getLocalName());
        try {
            AgentParameters ap = this.parseParameters();
            if (ap != null) {
                this.jasonBridgeAgArch = new JasonBridgeArch(this);
                this.jasonBridgeAgArch.init(ap);
                if (this.jasonBridgeAgArch.getTS().getSettings().verbose() >= 0) {
                    this.logger.setLevel(this.jasonBridgeAgArch.getTS().getSettings().logLevel());
                }
                this.registerAgInDF();
                this.tsBehaviour = new JasonTSReasoner();
                this.addBehaviour(this.tsBehaviour);
                this.logger.fine("Created from source " + ap.asSource);
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error creating JADE architecture.", e2);
        }
    }

    void wakeUp() {
        if (this.tsBehaviour != null) {
            this.tsBehaviour.restart();
        }
    }

    protected AgentParameters parseParameters() throws ParseException, IOException {
        Object[] args = this.getArguments();
        if (args == null || args.length == 0) {
            this.logger.info("No AgentSpeak source informed!");
            return null;
        }
        if (args[0] instanceof AgentParameters) {
            return (AgentParameters)args[0];
        }
        if (args[0].toString().equals("j-project")) {
            if (args.length != 3) {
                this.logger.log(Level.SEVERE, "To start agents from .mas2j file, you have to provide as parameters: (j-project,<file.mas2j>,<nameofagent in mas2j>)");
                this.logger.log(Level.SEVERE, "Current parameters are:");
                for (int i = 0; i < args.length; ++i) {
                    this.logger.log(Level.SEVERE, "   " + i + " = " + args[i]);
                }
                return null;
            }
            mas2j parser = new mas2j(new FileReader(args[1].toString()));
            MAS2JProject project = parser.mas();
            project.setupDefault();
            project.registerDirectives();
            ((Include)DirectiveProcessor.getDirective("include")).setSourcePath(project.getSourcePaths());
            AgentParameters ap = project.getAg(args[2].toString());
            if (ap == null) {
                this.logger.log(Level.SEVERE, "There is no agent '" + args[2] + "' in project '" + args[1] + "'.");
            } else {
                ap.asSource = new File(project.getSourcePaths().fixPath(ap.asSource.toString()));
            }
            if (JadeAgArch.isCartagoJadeCase(project)) {
                JadeAgArch.startCartagoNode(project.getEnvClass().getParametersArray());
            }
            return ap;
        }
        AgentParameters ap = new AgentParameters();
        ap.asSource = new File(args[0].toString());
        for (int i = 1; i < args.length; ++i) {
            if (args[i].toString().equals("arch")) {
                ap.addArchClass(args[++i].toString());
                continue;
            }
            if (!args[i].toString().equals("ag")) continue;
            ap.agClass = new ClassParameters(args[++i].toString());
        }
        return ap;
    }

    public static boolean isCartagoJadeCase(MAS2JProject project) {
        return project.getEnvClass() != null && project.getEnvClass().getClassName().equals("c4jason.CartagoEnvironment") && project.isJade();
    }

    public static synchronized void startCartagoNode(String[] args) {
        if (!cartagoStarted) {
            System.out.print("Starting cartago node....");
            System.out.println("**** not implemented!!!! ****");
        }
        cartagoStarted = true;
    }

    private void registerAgInDF() {
        DFAgentDescription dfa = new DFAgentDescription();
        dfa.setName(this.getAID());
        ServiceDescription vc = new ServiceDescription();
        vc.setType("jason");
        vc.setName(dfName);
        dfa.addServices(vc);
        try {
            DFService.register((Agent)this, (DFAgentDescription)dfa);
        }
        catch (FIPAException e2) {
            try {
                DFService.deregister((Agent)this);
                DFService.register((Agent)this, (DFAgentDescription)dfa);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error registering agent in DF", e2);
                this.logger.log(Level.SEVERE, "Error unregistering agent in DF", ex);
            }
        }
    }

    @Override
    public void doDelete() {
        try {
            this.running = false;
            if (this.jasonBridgeAgArch != null) {
                this.jasonBridgeAgArch.getFirstAgArch().stop();
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error in doDelete.", e2);
        }
        finally {
            super.doDelete();
        }
    }

    protected void takeDown() {
        this.logger.info("Finished!");
    }

    boolean processExecutionControlOntologyMsg() {
        ACLMessage m = this.receive(this.ts);
        if (m != null) {
            ACLMessage r = m.createReply();
            r.setPerformative(7);
            try {
                Document agStateDoc = this.jasonBridgeAgArch.getTS().getAg().getAgState();
                r.setContentObject((Serializable)((Object)agStateDoc));
                this.send(r);
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error sending message " + r, e2);
            }
        }
        if ((m = this.receive(this.tc)) != null) {
            int cycle = Integer.parseInt(m.getUserDefinedParameter("cycle"));
            this.logger.fine("new cycle: " + cycle);
            this.jasonBridgeAgArch.setCycleNumber(cycle);
            return true;
        }
        return false;
    }

    public void informCycleFinished(boolean breakpoint, int cycle) {
        try {
            ACLMessage m = new ACLMessage(7);
            m.addReceiver(this.controllerAID);
            m.setOntology(JadeExecutionControl.controllerOntology);
            m.setContent(breakpoint + "," + cycle);
            this.send(m);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error sending cycle finished.", e2);
        }
    }

    class JasonTSReasoner
    extends CyclicBehaviour {
        TransitionSystem ts;

        JasonTSReasoner() {
            this.ts = JadeAgArch.this.jasonBridgeAgArch.getTS();
        }

        public void action() {
            if (this.ts.getSettings().isSync()) {
                if (JadeAgArch.this.processExecutionControlOntologyMsg()) {
                    this.ts.reasoningCycle();
                    boolean isBreakPoint = false;
                    try {
                        isBreakPoint = this.ts.getC().getSelectedOption().getPlan().hasBreakpoint();
                        if (JadeAgArch.this.logger.isLoggable(Level.FINE)) {
                            JadeAgArch.this.logger.fine("Informing controller that I finished a reasoning cycle " + JadeAgArch.this.jasonBridgeAgArch.getCycleNumber() + ". Breakpoint is " + isBreakPoint);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    JadeAgArch.this.informCycleFinished(isBreakPoint, JadeAgArch.this.jasonBridgeAgArch.getCycleNumber());
                } else {
                    this.block(1000L);
                }
            } else {
                this.ts.reasoningCycle();
                if (this.ts.canSleep()) {
                    this.block(1000L);
                }
            }
        }
    }
}

