/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.centralised.BaseDialogGUI;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class StartNewAgentGUI
extends BaseDialogGUI {
    private static final long serialVersionUID = 1L;
    protected JTextField agName;
    protected JTextField agSource;
    protected JTextField archClass;
    protected JTextField agClass;
    protected JTextField nbAgs;
    protected JTextField agHost;
    protected JComboBox verbose;
    String openDir;

    public StartNewAgentGUI(Frame f, String title, String openDir) {
        super(f, title);
        this.openDir = openDir;
    }

    @Override
    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.agName = new JTextField(10);
        this.createField("Agent name", this.agName, "The agent name");
        this.agSource = new JTextField(15);
        JButton sourceBrowseBt = new JButton("Browse");
        sourceBrowseBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser chooser = new JFileChooser(StartNewAgentGUI.this.openDir);
                    chooser.setDialogTitle("Select the AgentSpeak source file");
                    chooser.setFileFilter(new AslFileFilter());
                    if (chooser.showOpenDialog(null) == 0) {
                        StartNewAgentGUI.this.agSource.setText(chooser.getSelectedFile().toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.createField("Source", this.agSource, sourceBrowseBt, "The path for the agent's source file (e.g. ../asl/code.asl). If left empty, the file will be the agent's name + .asl.");
        this.agClass = new JTextField(20);
        this.createField("Agent class", this.agClass, "The customisation class for the agent (<package.classname>). If not filled, the default agent class will be used.");
        this.archClass = new JTextField(20);
        this.createField("Architecture class", this.archClass, "The customisation class for the agent architecture (<package.classname>). If not filled, the default architecture will be used.");
        this.nbAgs = new JTextField(4);
        this.nbAgs.setText("1");
        this.createField("Number of agents", this.nbAgs, "The number of agents that will be instantiated from this declaration.");
        this.verbose = new JComboBox<String>(new String[]{"no output", "normal", "debug"});
        this.verbose.setSelectedIndex(1);
        this.createField("Verbose", this.verbose, "Set the verbose level");
        this.agHost = new JTextField(10);
        this.agHost.setText("localhost");
        this.createField("Host to run", this.agHost, "The host where this agent will run. The infrastructure must support distributed launching.");
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Agent parameters", 1, 2));
        p.add((Component)this.pLabels, "Center");
        p.add((Component)this.pFields, "East");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    @Override
    protected boolean ok() {
        final AgentParameters ap = this.getAgDecl();
        if (ap == null) {
            JOptionPane.showMessageDialog(this, "An agent name must be informed.");
            return false;
        }
        if (ap.asSource == null) {
            ap.asSource = new File(ap.name + "." + "asl");
        }
        if (!ap.asSource.exists()) {
            JOptionPane.showMessageDialog(this, "The source file '" + ap.asSource + "' does not exist!");
            return false;
        }
        new Thread(){

            @Override
            public void run() {
                boolean debug = BaseCentralisedMAS.getRunner().isDebug();
                boolean fs = BaseCentralisedMAS.getRunner().getControllerInfraTier() != null;
                RuntimeServicesInfraTier services = BaseCentralisedMAS.getRunner().getRuntimeServices();
                try {
                    String agClass = null;
                    if (ap.agClass != null) {
                        agClass = ap.agClass.getClassName();
                    }
                    for (int i = 0; i < ap.getNbInstances(); ++i) {
                        String name = ap.name;
                        if (ap.getNbInstances() > 1) {
                            name = name + (i + 1);
                        }
                        name = services.createAgent(name, ap.asSource.getAbsolutePath(), agClass, ap.getAgArchClasses(), null, ap.getAsSetts(debug, fs), null);
                        services.startAgent(name);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }.start();
        return true;
    }

    protected AgentParameters getAgDecl() {
        if (this.agName.getText().trim().length() == 0) {
            return null;
        }
        AgentParameters ap = new AgentParameters();
        ap.name = this.agName.getText().trim();
        if (Character.isUpperCase(ap.name.charAt(0))) {
            ap.name = Character.toLowerCase(ap.name.charAt(0)) + ap.name.substring(1);
        }
        if (this.verbose.getSelectedIndex() != 1) {
            ap.addOption("verbose", this.verbose.getSelectedIndex() + "");
        }
        if (this.agSource.getText().trim().length() > 0) {
            ap.asSource = this.agSource.getText().startsWith(File.separator) ? new File(this.agSource.getText().trim()) : new File(this.openDir + File.separator + this.agSource.getText().trim());
        }
        if (this.archClass.getText().trim().length() > 0) {
            ap.addArchClass(this.archClass.getText().trim());
        }
        if (this.agClass.getText().trim().length() > 0) {
            ap.agClass = new ClassParameters(this.agClass.getText().trim());
        }
        if (!this.nbAgs.getText().trim().equals("1")) {
            try {
                ap.setNbInstances(Integer.parseInt(this.nbAgs.getText().trim()));
            }
            catch (Exception e2) {
                System.err.println("Number of hosts is not a number!");
            }
        }
        if (!this.agHost.getText().trim().equals("localhost")) {
            ap.setHost(this.agHost.getText().trim());
        }
        return ap;
    }

    class AslFileFilter
    extends FileFilter {
        AslFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith("asl") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "AgentSpeak language source";
        }
    }
}

