/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.centralised.CentralisedAgArch;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CentralisedRuntimeServices
implements RuntimeServicesInfraTier {
    private static Logger logger = Logger.getLogger(CentralisedRuntimeServices.class.getName());
    protected BaseCentralisedMAS masRunner;

    public CentralisedRuntimeServices(BaseCentralisedMAS masRunner) {
        this.masRunner = masRunner;
    }

    protected CentralisedAgArch newAgInstance() {
        return new CentralisedAgArch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createAgent(String agName, String agSource, String agClass, List<String> archClasses, ClassParameters bbPars, Settings stts, Agent father) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating centralised agent " + agName + " from source " + agSource + " (agClass=" + agClass + ", archClass=" + archClasses + ", settings=" + stts);
        }
        AgentParameters ap = new AgentParameters();
        ap.setAgClass(agClass);
        ap.addArchClass(archClasses);
        ap.setBB(bbPars);
        if (stts == null) {
            stts = new Settings();
        }
        String prefix2 = null;
        if (father != null && father.getASLSrc().startsWith("ClassResource:")) {
            prefix2 = "ClassResource:/";
        }
        agSource = this.masRunner.getProject().getSourcePaths().fixPath(agSource, prefix2);
        String nb = "";
        Logger logger = CentralisedRuntimeServices.logger;
        synchronized (logger) {
            int n = 1;
            while (this.masRunner.getAg(agName + nb) != null) {
                nb = "_" + n++;
            }
            agName = agName + nb;
            CentralisedAgArch agArch = this.newAgInstance();
            agArch.setAgName(agName);
            agArch.createArchs(ap.getAgArchClasses(), ap.agClass.getClassName(), ap.getBBClass(), agSource, stts, this.masRunner);
            agArch.setEnvInfraTier(this.masRunner.getEnvironmentInfraTier());
            agArch.setControlInfraTier(this.masRunner.getControllerInfraTier());
            this.masRunner.addAg(agArch);
        }
        CentralisedRuntimeServices.logger.fine("Agent " + agName + " created!");
        return agName;
    }

    @Override
    public void startAgent(String agName) {
        CentralisedAgArch agArch = this.masRunner.getAg(agName);
        Thread agThread = new Thread(agArch);
        agArch.setThread(agThread);
        agThread.start();
    }

    @Override
    public AgArch clone(Agent source, List<String> archClasses, String agName) throws JasonException {
        CentralisedAgArch agArch = this.newAgInstance();
        agArch.setAgName(agName);
        agArch.setEnvInfraTier(this.masRunner.getEnvironmentInfraTier());
        agArch.setControlInfraTier(this.masRunner.getControllerInfraTier());
        this.masRunner.addAg(agArch);
        agArch.createArchs(archClasses, source, this.masRunner);
        this.startAgent(agName);
        return agArch.getUserAgArch();
    }

    @Override
    public Set<String> getAgentsNames() {
        return this.masRunner.getAgs().keySet();
    }

    @Override
    public int getAgentsQty() {
        return this.masRunner.getAgs().keySet().size();
    }

    @Override
    public boolean killAgent(String agName, String byAg) {
        logger.fine("Killing centralised agent " + agName);
        CentralisedAgArch ag = this.masRunner.getAg(agName);
        if (ag != null && ag.getTS().getAg().killAcc(byAg)) {
            ag.stopAg();
            this.masRunner.delAg(agName);
            return true;
        }
        return false;
    }

    @Override
    public void stopMAS() throws Exception {
        this.masRunner.finish();
    }
}

