/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.ReceiverNotFoundException;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Message;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.CentralisedExecutionControl;
import jason.infra.centralised.CentralisedRuntimeServices;
import jason.infra.centralised.MsgListener;
import jason.infra.centralised.RConf;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import jason.util.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CentralisedAgArch
extends AgArch
implements Runnable {
    protected CentralisedEnvironment infraEnv = null;
    private CentralisedExecutionControl infraControl = null;
    private BaseCentralisedMAS masRunner = BaseCentralisedMAS.getRunner();
    private String agName = "";
    private volatile boolean running = true;
    private Queue<Message> mbox = new ConcurrentLinkedQueue<Message>();
    protected Logger logger = Logger.getLogger(CentralisedAgArch.class.getName());
    private static List<MsgListener> msgListeners = null;
    private Thread myThread = null;
    private Object sleepSync = new Object();
    private int sleepTime = 50;
    public static final int MAX_SLEEP = 1000;
    private Object syncMonitor = new Object();
    private volatile boolean inWaitSyncMonitor = false;
    private RConf conf;
    private int cycles = 1;
    private int cyclesSense = 1;
    private int cyclesDeliberate = 1;
    private int cyclesAct = 5;

    public static void addMsgListener(MsgListener l) {
        if (msgListeners == null) {
            msgListeners = new ArrayList<MsgListener>();
        }
        msgListeners.add(l);
    }

    public static void removeMsgListener(MsgListener l) {
        msgListeners.remove(l);
    }

    public void createArchs(List<String> agArchClasses, String agClass, ClassParameters bbPars, String asSrc, Settings stts, BaseCentralisedMAS masRunner) throws JasonException {
        try {
            this.masRunner = masRunner;
            Agent.create(this, agClass, bbPars, asSrc, stts);
            this.insertAgArch(this);
            this.createCustomArchs(agArchClasses);
            if (stts.getUserParameter("mindinspector") != null) {
                this.insertAgArch((AgArch)Class.forName(Config.get().getMindInspectorArchClassName()).newInstance());
                this.getFirstAgArch().init();
            }
            this.setLogger();
        }
        catch (Exception e2) {
            this.running = false;
            throw new JasonException("as2j: error creating the agent class! - " + e2.getMessage(), e2);
        }
    }

    public void createArchs(List<String> agArchClasses, Agent ag, BaseCentralisedMAS masRunner) throws JasonException {
        try {
            this.masRunner = masRunner;
            this.setTS(ag.clone(this).getTS());
            this.insertAgArch(this);
            this.createCustomArchs(agArchClasses);
            this.setLogger();
        }
        catch (Exception e2) {
            this.running = false;
            throw new JasonException("as2j: error creating the agent class! - ", e2);
        }
    }

    public void stopAg() {
        this.running = false;
        this.wake();
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        this.getTS().getAg().stopAg();
        this.getUserAgArch().stop();
    }

    public void setLogger() {
        this.logger = Logger.getLogger(CentralisedAgArch.class.getName() + "." + this.getAgName());
        if (this.getTS().getSettings().verbose() >= 0) {
            this.logger.setLevel(this.getTS().getSettings().logLevel());
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setAgName(String name) throws JasonException {
        if (name.equals("self")) {
            throw new JasonException("an agent cannot be named 'self'!");
        }
        if (name.equals("percept")) {
            throw new JasonException("an agent cannot be named 'percept'!");
        }
        this.agName = name;
    }

    @Override
    public String getAgName() {
        return this.agName;
    }

    public AgArch getUserAgArch() {
        return this.getFirstAgArch();
    }

    public void setEnvInfraTier(CentralisedEnvironment env) {
        this.infraEnv = env;
    }

    public CentralisedEnvironment getEnvInfraTier() {
        return this.infraEnv;
    }

    public void setControlInfraTier(CentralisedExecutionControl pControl) {
        this.infraControl = pControl;
    }

    public CentralisedExecutionControl getControlInfraTier() {
        return this.infraControl;
    }

    public void setThread(Thread t) {
        this.myThread = t;
        this.myThread.setName(this.agName);
    }

    public void startThread() {
        this.myThread.start();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void sense() {
        TransitionSystem ts = this.getTS();
        int i = 0;
        do {
            ts.sense();
        } while (this.running && ++i < this.cyclesSense && !ts.canSleepSense());
    }

    protected void deliberate() {
        TransitionSystem ts = this.getTS();
        int i = 0;
        while (this.running && i++ < this.cyclesDeliberate && !ts.canSleepDeliberate()) {
            ts.deliberate();
        }
    }

    protected void act() {
        TransitionSystem ts = this.getTS();
        int i = 0;
        int ca = this.cyclesAct;
        if (this.cyclesAct == 9999) {
            ca = ts.getC().getIntentions().size();
        }
        while (this.running && i++ < ca && !ts.canSleepAct()) {
            ts.act();
        }
    }

    protected void reasoningCycle() {
        this.sense();
        this.deliberate();
        this.act();
    }

    @Override
    public void run() {
        TransitionSystem ts = this.getTS();
        while (this.running) {
            if (ts.getSettings().isSync()) {
                this.waitSyncSignal();
                this.reasoningCycle();
                boolean isBreakPoint = false;
                try {
                    isBreakPoint = ts.getC().getSelectedOption().getPlan().hasBreakpoint();
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Informing controller that I finished a reasoning cycle " + this.getCycleNumber() + ". Breakpoint is " + isBreakPoint);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.informCycleFinished(isBreakPoint, this.getCycleNumber());
                continue;
            }
            this.incCycleNumber();
            this.reasoningCycle();
            if (!ts.canSleep()) continue;
            this.sleep();
        }
        this.logger.fine("I finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep() {
        block7: {
            try {
                if (this.getTS().getSettings().isSync()) break block7;
                Object object = this.sleepSync;
                synchronized (object) {
                    this.sleepSync.wait(this.sleepTime);
                    if (this.sleepTime < 1000) {
                        this.sleepTime += 100;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, "Error in sleep.", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wake() {
        Object object = this.sleepSync;
        synchronized (object) {
            this.sleepTime = 50;
            this.sleepSync.notifyAll();
        }
    }

    @Override
    public void wakeUpSense() {
        this.wake();
    }

    @Override
    public void wakeUpDeliberate() {
        this.wake();
    }

    @Override
    public void wakeUpAct() {
        this.wake();
    }

    @Override
    public Collection<Literal> perceive() {
        super.perceive();
        if (this.infraEnv == null) {
            return null;
        }
        Collection<Literal> percepts = this.infraEnv.getUserEnvironment().getPercepts(this.getAgName());
        if (this.logger.isLoggable(Level.FINE) && percepts != null) {
            this.logger.fine("percepts: " + percepts);
        }
        return percepts;
    }

    @Override
    public void sendMsg(Message m) throws ReceiverNotFoundException {
        CentralisedAgArch rec;
        if (m.getSender() == null) {
            m.setSender(this.getAgName());
        }
        if ((rec = this.masRunner.getAg(m.getReceiver())) == null) {
            if (this.isRunning()) {
                throw new ReceiverNotFoundException("Receiver '" + m.getReceiver() + "' does not exist! Could not send " + m);
            }
            return;
        }
        rec.receiveMsg(m.clone());
        if (msgListeners != null) {
            for (MsgListener l : msgListeners) {
                l.msgSent(m);
            }
        }
    }

    public void receiveMsg(Message m) {
        this.mbox.offer(m);
        this.wakeUpSense();
    }

    @Override
    public void broadcast(Message m) throws Exception {
        for (String agName : this.masRunner.getAgs().keySet()) {
            if (agName.equals(this.getAgName())) continue;
            m.setReceiver(agName);
            this.sendMsg(m);
        }
    }

    @Override
    public void checkMail() {
        Circumstance C = this.getTS().getC();
        Message im = this.mbox.poll();
        while (im != null) {
            C.addMsg(im);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("received message: " + im);
            }
            im = this.mbox.poll();
        }
    }

    public Collection<Message> getMBox() {
        return this.mbox;
    }

    @Override
    public void act(ActionExec action) {
        if (this.isRunning()) {
            if (this.infraEnv != null) {
                this.infraEnv.act(this.getAgName(), action);
            } else {
                action.setResult(false);
                action.setFailureReason(new Atom("noenv"), "no environment configured!");
                this.actionExecuted(action);
            }
        }
    }

    @Override
    public boolean canSleep() {
        return this.mbox.isEmpty() && this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSyncSignal() {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.inWaitSyncMonitor = true;
                this.syncMonitor.wait();
                this.inWaitSyncMonitor = false;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e2) {
            this.logger.log(Level.WARNING, "Error waiting sync (1)", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSyncSignal() {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                while (!this.inWaitSyncMonitor && this.isRunning()) {
                    this.syncMonitor.wait(50L);
                }
                this.syncMonitor.notifyAll();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e2) {
            this.logger.log(Level.WARNING, "Error waiting sync (2)", e2);
        }
    }

    public void informCycleFinished(boolean breakpoint, int cycle) {
        this.infraControl.receiveFinishedCycle(this.getAgName(), breakpoint, cycle);
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new CentralisedRuntimeServices(this.masRunner);
    }

    public void setConf(RConf conf) {
        this.conf = conf;
    }

    public RConf getConf() {
        return this.conf;
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    public int getCyclesSense() {
        return this.cyclesSense;
    }

    public void setCyclesSense(int cyclesSense) {
        this.cyclesSense = cyclesSense;
    }

    public int getCyclesDeliberate() {
        return this.cyclesDeliberate;
    }

    public void setCyclesDeliberate(int cyclesDeliberate) {
        this.cyclesDeliberate = cyclesDeliberate;
    }

    public int getCyclesAct() {
        return this.cyclesAct;
    }

    public void setCyclesAct(int cyclesAct) {
        this.cyclesAct = cyclesAct;
    }
}

