/*
 * Decompiled with CFR 0.152.
 */
package jason.functions;

import jason.JasonException;
import jason.asSemantics.DefaultArithFunction;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.ListTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;

public class Max
extends DefaultArithFunction {
    @Override
    public String getName() {
        return "math.max";
    }

    @Override
    public double evaluate(TransitionSystem ts, Term[] args) throws Exception {
        if (args[0].isNumeric() && args[1].isNumeric()) {
            double n0 = ((NumberTerm)args[0]).solve();
            double n1 = ((NumberTerm)args[1]).solve();
            return Math.max(n0, n1);
        }
        if (args[0].isList()) {
            double max2 = Double.MIN_VALUE;
            for (Term t : (ListTerm)args[0]) {
                double n;
                if (!t.isNumeric() || !((n = ((NumberTerm)t).solve()) > max2)) continue;
                max2 = n;
            }
            return max2;
        }
        throw new JasonException(this.getName() + " is not implemented for type '" + args[0] + "'.");
    }

    @Override
    public boolean checkArity(int a) {
        return a == 1 || a == 2;
    }
}

