/*
 * Decompiled with CFR 0.152.
 */
package jason.environment.grid;

import jason.environment.grid.Area;
import java.io.Serializable;

public final class Location
implements Serializable {
    public int x;
    public int y;

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int distanceManhattan(Location l) {
        return Math.abs(this.x - l.x) + Math.abs(this.y - l.y);
    }

    public int distance(Location l) {
        return Math.abs(this.x - l.x) + Math.abs(this.y - l.y);
    }

    public double distanceEuclidean(Location l) {
        return Math.sqrt(Math.pow(this.x - l.x, 2.0) + Math.pow(this.y - l.y, 2.0));
    }

    public int distanceChebyshev(Location l) {
        return Math.max(Math.abs(this.x - l.x), Math.abs(this.y - l.y));
    }

    public int maxBorder(Location l) {
        return Math.max(Math.abs(this.x - l.x), Math.abs(this.y - l.y));
    }

    public boolean isInArea(Location tl, Location br) {
        return this.x >= tl.x && this.x <= br.x && this.y >= tl.y && this.y <= br.y;
    }

    public boolean isInArea(Area a) {
        return a.contains(this);
    }

    public boolean isNeigbour(Location l) {
        return this.distance(l) == 1 || this.equals(l) || Math.abs(this.x - l.x) == 1 && Math.abs(this.y - l.y) == 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public Object clone() {
        return new Location(this.x, this.y);
    }

    public String toString() {
        return this.x + "," + this.y;
    }
}

