/*
 * Decompiled with CFR 0.152.
 */
package jason.environment;

import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.environment.EnvironmentInfraTier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Environment {
    private static Logger logger = Logger.getLogger(Environment.class.getName());
    private List<Literal> percepts = Collections.synchronizedList(new ArrayList());
    private Map<String, List<Literal>> agPercepts = new ConcurrentHashMap<String, List<Literal>>();
    private boolean isRunning = true;
    private EnvironmentInfraTier environmentInfraTier = null;
    private Set<String> uptodateAgs = Collections.synchronizedSet(new HashSet());
    protected ExecutorService executor;

    public Environment(int n) {
        this.executor = Executors.newFixedThreadPool(n);
    }

    public Environment() {
        this(4);
    }

    public void init(String[] args) {
    }

    public void stop() {
        this.isRunning = false;
        this.executor.shutdownNow();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setEnvironmentInfraTier(EnvironmentInfraTier je) {
        this.environmentInfraTier = je;
    }

    public EnvironmentInfraTier getEnvironmentInfraTier() {
        return this.environmentInfraTier;
    }

    public Logger getLogger() {
        return logger;
    }

    public void informAgsEnvironmentChanged(Collection<String> agents) {
        if (this.environmentInfraTier != null) {
            this.environmentInfraTier.informAgsEnvironmentChanged(agents);
        }
    }

    public void informAgsEnvironmentChanged(String ... agents) {
        if (this.environmentInfraTier != null) {
            this.environmentInfraTier.informAgsEnvironmentChanged(agents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Literal> getPercepts(String agName) {
        List<Literal> list2;
        if (this.uptodateAgs.contains(agName)) {
            return null;
        }
        this.uptodateAgs.add(agName);
        int size = this.percepts.size();
        List<Literal> agl = this.agPercepts.get(agName);
        if (agl != null) {
            size += agl.size();
        }
        ArrayList<Literal> p = new ArrayList<Literal>(size);
        if (!this.percepts.isEmpty()) {
            list2 = this.percepts;
            synchronized (list2) {
                p.addAll(this.percepts);
            }
        }
        if (agl != null) {
            list2 = agl;
            synchronized (list2) {
                p.addAll(agl);
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Literal> consultPercepts(String agName) {
        List<Literal> list2;
        int size = this.percepts.size();
        List<Literal> agl = this.agPercepts.get(agName);
        if (agl != null) {
            size += agl.size();
        }
        ArrayList<Literal> p = new ArrayList<Literal>(size);
        if (!this.percepts.isEmpty()) {
            list2 = this.percepts;
            synchronized (list2) {
                p.addAll(this.percepts);
            }
        }
        if (agl != null) {
            list2 = agl;
            synchronized (list2) {
                p.addAll(agl);
            }
        }
        return p;
    }

    public void addPercept(Literal ... perceptions) {
        if (perceptions != null) {
            for (Literal per : perceptions) {
                if (this.percepts.contains(per)) continue;
                this.percepts.add(per);
            }
            this.uptodateAgs.clear();
        }
    }

    public boolean removePercept(Literal per) {
        if (per != null) {
            this.uptodateAgs.clear();
            return this.percepts.remove(per);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removePerceptsByUnif(Literal per) {
        int c = 0;
        if (!this.percepts.isEmpty()) {
            List<Literal> list2 = this.percepts;
            synchronized (list2) {
                Iterator<Literal> i = this.percepts.iterator();
                while (i.hasNext()) {
                    Literal l = i.next();
                    if (!new Unifier().unifies(l, per)) continue;
                    i.remove();
                    ++c;
                }
            }
            if (c > 0) {
                this.uptodateAgs.clear();
            }
        }
        return c;
    }

    public void clearPercepts() {
        if (!this.percepts.isEmpty()) {
            this.uptodateAgs.clear();
            this.percepts.clear();
        }
    }

    public boolean containsPercept(Literal per) {
        if (per != null) {
            return this.percepts.contains(per);
        }
        return false;
    }

    public void addPercept(String agName, Literal ... per) {
        if (per != null && agName != null) {
            List<Literal> agl = this.agPercepts.get(agName);
            if (agl == null) {
                agl = Collections.synchronizedList(new ArrayList());
                this.agPercepts.put(agName, agl);
            }
            for (Literal p : per) {
                if (agl.contains(p)) continue;
                this.uptodateAgs.remove(agName);
                agl.add(p);
            }
        }
    }

    public boolean removePercept(String agName, Literal per) {
        List<Literal> agl;
        if (per != null && agName != null && (agl = this.agPercepts.get(agName)) != null) {
            this.uptodateAgs.remove(agName);
            return agl.remove(per);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removePerceptsByUnif(String agName, Literal per) {
        List<Literal> agl;
        int c = 0;
        if (per != null && agName != null && (agl = this.agPercepts.get(agName)) != null) {
            List<Literal> list2 = agl;
            synchronized (list2) {
                Iterator<Literal> i = agl.iterator();
                while (i.hasNext()) {
                    Literal l = i.next();
                    if (!new Unifier().unifies(l, per)) continue;
                    i.remove();
                    ++c;
                }
            }
            if (c > 0) {
                this.uptodateAgs.remove(agName);
            }
        }
        return c;
    }

    public boolean containsPercept(String agName, Literal per) {
        List<Literal> agl;
        if (per != null && agName != null && (agl = this.agPercepts.get(agName)) != null) {
            return agl.contains(per);
        }
        return false;
    }

    public void clearPercepts(String agName) {
        List<Literal> agl;
        if (agName != null && (agl = this.agPercepts.get(agName)) != null) {
            this.uptodateAgs.remove(agName);
            agl.clear();
        }
    }

    public void clearAllPercepts() {
        this.clearPercepts();
        for (String ag : this.agPercepts.keySet()) {
            this.clearPercepts(ag);
        }
    }

    public void scheduleAction(final String agName, final Structure action, final Object infraData) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        boolean success = Environment.this.executeAction(agName, action);
                        Environment.this.environmentInfraTier.actionExecuted(agName, action, success, infraData);
                    }
                    catch (Exception ie) {
                        if (ie instanceof InterruptedException) break block2;
                        logger.log(Level.WARNING, "act error!", ie);
                    }
                }
            }
        });
    }

    public boolean executeAction(String agName, Structure act) {
        logger.info("The action " + act + " done by " + agName + " is not implemented in the default environment.");
        return false;
    }
}

