/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax.directives;

import jason.asSemantics.Agent;
import jason.asSyntax.Atom;
import jason.asSyntax.Pred;
import jason.asSyntax.StringTerm;
import jason.asSyntax.directives.DefaultDirective;
import jason.asSyntax.directives.Directive;
import jason.asSyntax.directives.NameSpace;
import jason.asSyntax.parser.as2j;
import jason.runtime.SourcePath;
import jason.util.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Include
extends DefaultDirective
implements Directive {
    static Logger logger = Logger.getLogger(Include.class.getName());
    private SourcePath aslSourcePath = new SourcePath();

    @Override
    public Agent process(Pred directive, Agent outerContent, Agent innerContent) {
        if (outerContent == null) {
            return null;
        }
        String file = ((StringTerm)directive.getTerm(0)).getString().replaceAll("\\\\", "/");
        try {
            InputStream in = null;
            if (file.startsWith("$")) {
                String jar = file.substring(1, file.indexOf("/"));
                if (Config.get().get(jar) == null) {
                    logger.log(Level.SEVERE, "The included file '" + jar + "' is not configured");
                    return null;
                }
                String path = Config.get().get(jar).toString();
                file = "jar:file:" + path + "!" + file.substring(file.indexOf("/"));
                in = new URL(file).openStream();
            } else {
                String outerPrefix = outerContent.getASLSrc();
                if (outerContent != null && outerPrefix != null) {
                    if (outerPrefix.startsWith("jar")) {
                        outerPrefix = outerPrefix.substring(0, outerPrefix.indexOf("!") + 1) + "/";
                        file = this.aslSourcePath.fixPath(file, outerPrefix);
                        in = new URL(file).openStream();
                    } else if (outerPrefix.startsWith("ClassResource:")) {
                        int posSlash = outerPrefix.lastIndexOf("/");
                        SourcePath newpath = new SourcePath();
                        if (outerPrefix.indexOf("/") != posSlash) {
                            newpath.addPath(outerPrefix.substring("ClassResource:".length() + 1, posSlash));
                        }
                        newpath.addAll(this.aslSourcePath);
                        file = newpath.fixPath(file, "ClassResource:/");
                        in = Agent.class.getResource(file.substring("ClassResource:".length())).openStream();
                    } else if (outerPrefix.startsWith("file:") || outerPrefix.startsWith("http:") || outerPrefix.startsWith("https:")) {
                        URL url = new URL(new URL(outerPrefix), file);
                        file = url.toString();
                        in = url.openStream();
                    } else if (file.startsWith("jar:") || file.startsWith("file:") || file.startsWith("http:") || file.startsWith("https:")) {
                        URL url = new URL(file);
                        file = url.toString();
                        in = url.openStream();
                    } else {
                        SourcePath newpath = new SourcePath();
                        newpath.addPath(new File(outerPrefix).getAbsoluteFile().getParent());
                        newpath.addAll(this.aslSourcePath);
                        file = newpath.fixPath(file, null);
                        in = new FileInputStream(file);
                    }
                } else {
                    in = new FileInputStream(this.aslSourcePath.fixPath(file, null));
                }
            }
            Atom ns = directive.getNS();
            if (directive.getArity() > 1) {
                if (directive.getTerm(1).isVar()) {
                    ns = new Atom("ns" + NameSpace.getUniqueID());
                    directive.setTerm(1, ns);
                } else if (!directive.getTerm(1).isAtom()) {
                    logger.log(Level.SEVERE, "The second parameter of the directive include (the namespace) should be an atom and not " + directive.getTerm(1) + ". It is being ignored!");
                } else {
                    ns = new Atom(((Atom)directive.getTerm(1)).getFunctor());
                }
            }
            Agent ag = new Agent();
            ag.initAg();
            ag.setASLSrc(file);
            as2j sparser = new as2j(in);
            sparser.setNS(ns);
            sparser.agent(ag);
            logger.fine("as2j: AgentSpeak program '" + file + "' parsed successfully!");
            return ag;
        }
        catch (FileNotFoundException e2) {
            logger.log(Level.SEVERE, "The included file '" + file + "' was not found! (it is being included in the agent '" + outerContent.getASLSrc() + "')");
        }
        catch (Exception e3) {
            logger.log(Level.SEVERE, "as2j: error parsing \"" + file + "\"", e3);
        }
        return null;
    }

    public void setSourcePath(SourcePath sp) {
        this.aslSourcePath = sp;
    }

    public SourcePath getSourcePaths() {
        return this.aslSourcePath;
    }
}

