/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax.directives;

import jason.asSyntax.Pred;
import jason.asSyntax.directives.Directive;
import jason.asSyntax.directives.FunctionRegister;
import jason.asSyntax.directives.Include;
import jason.asSyntax.directives.NameSpace;
import jason.asSyntax.patterns.goal.BC;
import jason.asSyntax.patterns.goal.BDG;
import jason.asSyntax.patterns.goal.DG;
import jason.asSyntax.patterns.goal.EBDG;
import jason.asSyntax.patterns.goal.MG;
import jason.asSyntax.patterns.goal.OMC;
import jason.asSyntax.patterns.goal.RC;
import jason.asSyntax.patterns.goal.SGA;
import jason.asSyntax.patterns.goal.SMC;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectiveProcessor {
    static Logger logger = Logger.getLogger(DirectiveProcessor.class.getName());
    private static Map<String, Class> directives = new HashMap<String, Class>();
    private Map<String, Directive> instances = new HashMap<String, Directive>();
    private static Map<String, Directive> singletons = new HashMap<String, Directive>();

    public static void registerDirective(String id, Class d) {
        directives.put(id, d);
    }

    public static Directive getDirective(String id) {
        Directive d = singletons.get(id);
        if (d != null) {
            return d;
        }
        Class c = directives.get(id);
        if (c == null) {
            logger.log(Level.SEVERE, "Unknown directive " + id);
            return null;
        }
        try {
            d = (Directive)c.newInstance();
            if (d.isSingleton()) {
                singletons.put(id, d);
            }
            return d;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public Directive getInstance(Pred directive) {
        return this.getInstance(directive.getFunctor());
    }

    public Directive getInstance(String id) {
        Directive d = this.instances.get(id);
        if (d != null) {
            return d;
        }
        d = singletons.get(id);
        if (d != null) {
            return d;
        }
        Class c = directives.get(id);
        if (c == null) {
            logger.log(Level.SEVERE, "Unknown directive " + id);
            return null;
        }
        try {
            d = (Directive)c.newInstance();
            if (d.isSingleton()) {
                singletons.put(id, d);
            } else {
                this.instances.put(id, d);
            }
            return d;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    static {
        DirectiveProcessor.registerDirective("include", Include.class);
        DirectiveProcessor.registerDirective("register_function", FunctionRegister.class);
        DirectiveProcessor.registerDirective("namespace", NameSpace.class);
        DirectiveProcessor.registerDirective("dg", DG.class);
        DirectiveProcessor.registerDirective("bdg", BDG.class);
        DirectiveProcessor.registerDirective("ebdg", EBDG.class);
        DirectiveProcessor.registerDirective("bc", BC.class);
        DirectiveProcessor.registerDirective("smc", SMC.class);
        DirectiveProcessor.registerDirective("rc", RC.class);
        DirectiveProcessor.registerDirective("omc", OMC.class);
        DirectiveProcessor.registerDirective("mg", MG.class);
        DirectiveProcessor.registerDirective("sga", SGA.class);
    }
}

