/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule
extends LiteralImpl {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Rule.class.getName());
    private LogicalFormula body = null;
    private boolean isTerm = false;

    public Rule(Literal head, LogicalFormula body) {
        super(head);
        if (head.isRule()) {
            logger.log(Level.SEVERE, "The rule head (" + head + ") is a rule!", new Exception());
        } else if (this.isInternalAction()) {
            logger.log(Level.SEVERE, "The rule head (" + head + ") can not be an internal action!", new Exception());
        } else if (head == LTrue || head == LFalse) {
            logger.log(Level.SEVERE, "The rule head (" + head + ") can not be a true or false!", new Exception());
        }
        this.body = body;
    }

    public Rule(Rule r, Unifier u) {
        super((Literal)r, u);
        this.isTerm = r.isTerm;
        this.body = (LogicalFormula)r.body.capply(u);
        this.predicateIndicatorCache = null;
    }

    @Override
    public boolean isRule() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isGround() {
        return false;
    }

    public void setAsTerm(boolean b) {
        this.isTerm = b;
    }

    public boolean isTerm() {
        return this.isTerm;
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof Rule) {
            Rule r = (Rule)o;
            return super.equals(o) && this.body.equals(r.body);
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        return super.calcHashCode() + this.body.hashCode();
    }

    public LogicalFormula getBody() {
        return this.body;
    }

    public Literal getHead() {
        return new LiteralImpl(this);
    }

    @Override
    public Literal makeVarsAnnon(Unifier un) {
        if (this.body instanceof Literal) {
            ((Literal)this.body).makeVarsAnnon(un);
        }
        return super.makeVarsAnnon(un);
    }

    @Override
    public Term capply(Unifier u) {
        return new Rule(this, u);
    }

    @Override
    public Rule clone() {
        Rule r = new Rule((Literal)super.clone(), (LogicalFormula)this.body.clone());
        r.predicateIndicatorCache = null;
        r.resetHashCodeCache();
        r.isTerm = this.isTerm;
        return r;
    }

    public Literal headClone() {
        return (Literal)super.clone();
    }

    public Literal headCApply(Unifier u) {
        return (Literal)super.capply(u);
    }

    @Override
    public String toString() {
        if (this.isTerm()) {
            return "{ " + super.toString() + " :- " + this.body + " }";
        }
        return super.toString() + " :- " + this.body;
    }

    @Override
    public boolean hasVar(VarTerm t, Unifier u) {
        if (super.hasVar(t, u)) {
            return true;
        }
        return this.body.hasVar(t, u);
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        super.countVars(c);
        this.body.countVars(c);
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("rule");
        Element h = document.createElement("head");
        h.appendChild(super.getAsDOM(document));
        Element b = document.createElement("context");
        b.appendChild(this.body.getAsDOM(document));
        u.appendChild(h);
        u.appendChild(b);
        return u;
    }
}

